/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaqz;
import com.google.android.gms.internal.zzarb;
import com.google.android.gms.internal.zzark;

class zzate
extends BroadcastReceiver {
    private static String zza = zzate.class.getName();
    private final zzark zzb;
    private boolean zzc;
    private boolean zzd;

    zzate(zzark zzark2) {
        zzbq.zza((Object)zzark2);
        this.zzb = zzark2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zze();
        String string = intent.getAction();
        this.zzb.zze().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzf();
            if (this.zzd != bl) {
                this.zzd = bl;
                boolean bl2 = bl;
                zzaqz zzaqz2 = this.zzb.zzh();
                zzaqz2.zza("Network connectivity status changed", bl2);
                zzaqz2.zzn().zza(new zzarb(zzaqz2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zza)) {
                zzaqz zzaqz3 = this.zzb.zzh();
                zzaqz3.zzb("Radio powered up");
                zzaqz3.zzd();
            }
            return;
        }
        this.zzb.zze().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zza() {
        this.zze();
        if (this.zzc) {
            return;
        }
        Context context = this.zzb.zza();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzd = this.zzf();
        this.zzb.zze().zza("Registering connectivity change receiver. Network connected", this.zzd);
        this.zzc = true;
    }

    private final void zze() {
        this.zzb.zze();
        this.zzb.zzh();
    }

    public final void zzb() {
        if (!this.zzc) {
            return;
        }
        this.zzb.zze().zzb("Unregistering connectivity change receiver");
        this.zzc = false;
        this.zzd = false;
        Context context = this.zzb.zza();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzb.zze().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzc() {
        Context context = this.zzb.zza();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zza, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean zzd() {
        if (!this.zzc) {
            this.zzb.zze().zze("Connectivity unknown. Receiver not registered");
        }
        return this.zzd;
    }

    private final boolean zzf() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzb.zza().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

