/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzarj;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzasb;
import com.google.android.gms.internal.zzash;
import com.google.android.gms.internal.zzasl;
import com.google.android.gms.internal.zzast;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

@Hide
final class zzatf
extends zzari {
    private final String zza;
    private final zzatp zzb;
    private static final byte[] zzc = "\n".getBytes();

    zzatf(zzark zzark2) {
        super(zzark2);
        String string = Build.ID;
        String string2 = Build.MODEL;
        String string3 = zzatt.zza(Locale.getDefault());
        String string4 = Build.VERSION.RELEASE;
        String string5 = zzarj.zza;
        String string6 = "GoogleAnalytics";
        this.zza = String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string6, string5, string4, string3, string2, string);
        this.zzb = new zzatp(zzark2.zzc());
    }

    @Override
    protected final void zza() {
        this.zza("Network initialized. User agent", (Object)this.zza);
    }

    public final boolean zzb() {
        zzk.zzd();
        this.zzz();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzk().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {}
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzb("No network connectivity");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Hide
    public final List<Long> zza(List<zzasy> var1_1) {
        block9: {
            zzk.zzd();
            this.zzz();
            zzbq.zza(var1_1);
            if (!this.zzm().zzk().isEmpty() && this.zzb.zza((long)zzast.zzv.zza().intValue() * 1000L)) break block9;
            var2_2 = false;
            ** GOTO lbl-1000
        }
        v0 = var2_2 = zzasb.zza(zzast.zzp.zza()) != zzasb.zza;
        if (zzash.zza(zzast.zzq.zza()) == zzash.zza) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var3_3 = false;
        }
        if (var2_2) {
            var6_4 = var3_3;
            var5_5 = var1_1;
            var4_6 = this;
            zzbq.zzb((boolean)(var5_5.isEmpty() == false));
            var4_6.zza("Uploading batched hits. compression, count", var6_4, var5_5.size());
            var7_7 = new zzatg(var4_6);
            var8_8 = new ArrayList<Long>();
            for (zzasy var10_10 : var5_5) {
                if (!var7_7.zza(var10_10)) break;
                var8_8.add(var10_10.zzc());
            }
            if (var7_7.zza() == 0) {
                return var8_8;
            }
            var9_9 = var4_6.zzd();
            if (var9_9 == null) {
                var4_6.zzf("Failed to build batching endpoint url");
            } else {
                var10_11 = var6_4 != false ? var4_6.zzb(var9_9, var7_7.zzb()) : var4_6.zza(var9_9, var7_7.zzb());
                if (200 == var10_11) {
                    var4_6.zza("Batched upload completed. Hits batched", var7_7.zza());
                    return var8_8;
                }
                var4_6.zza("Network error uploading hits. status code", var10_11);
                if (var4_6.zzm().zzk().contains(var10_11)) {
                    var4_6.zze("Server instructed the client to stop batching");
                    var4_6.zzb.zza();
                }
            }
            return Collections.emptyList();
        }
        return this.zzb(var1_1);
    }

    /*
     * Unable to fully structure code
     */
    @Hide
    private final List<Long> zzb(List<zzasy> var1_1) {
        var2_2 = new ArrayList<Long>(var1_1.size());
        var3_3 = var1_1.iterator();
        while (var3_3.hasNext()) {
            block4: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                block6: {
                                    block3: {
                                        var6_6 = var4_4 = var3_3.next();
                                        var5_5 = this;
                                        zzbq.zza((Object)var6_6);
                                        var7_7 = var5_5.zza(var6_6, var6_6.zzf() == false);
                                        if (var7_7 != null) break block3;
                                        var5_5.zzl().zza(var6_6, "Error formatting hit for upload");
                                        v0 = true;
                                        break block4;
                                    }
                                    if (var7_7.length() > zzast.zzo.zza()) break block5;
                                    var8_8 = var5_5.zza(var6_6, var7_7);
                                    if (var8_8 != null) break block6;
                                    var5_5.zzf("Failed to build collect GET endpoint url");
                                    ** GOTO lbl-1000
                                }
                                v0 = var5_5.zza((URL)var8_8) == 200;
                                break block4;
                            }
                            var7_7 = var5_5.zza(var6_6, false);
                            if (var7_7 != null) break block7;
                            var5_5.zzl().zza(var6_6, "Error formatting hit for POST upload");
                            v0 = true;
                            break block4;
                        }
                        v1 = var7_7.getBytes();
                        var8_8 = v1;
                        if (v1.length <= zzast.zzs.zza()) break block8;
                        var5_5.zzl().zza(var6_6, "Hit payload exceeds size limit");
                        v0 = true;
                        break block4;
                    }
                    var9_9 = var5_5.zza(var6_6);
                    if (var9_9 != null) break block9;
                    var5_5.zzf("Failed to build collect POST endpoint url");
                    ** GOTO lbl-1000
                }
                if (var5_5.zza(var9_9, (byte[])var8_8) == 200) {
                    v0 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v0 = false;
                }
            }
            if (!v0) break;
            var2_2.add(var4_4.zzc());
            if (var2_2.size() < zzasl.zzf()) continue;
        }
        return var2_2;
    }

    private final int zza(URL uRL) {
        zzbq.zza((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.connect();
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzp().zzh();
            }
            this.zzb("GET status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            return 0;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private final int zza(URL uRL, byte[] byArray) {
        zzbq.zza((Object)uRL);
        zzbq.zza((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (zzatf.zzx()) {
            this.zza("Post payload\n", (Object)new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.zzk().getPackageName();
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzp().zzh();
            }
            this.zzb("POST status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private final int zzb(URL uRL, byte[] byArray) {
        zzbq.zza((Object)uRL);
        zzbq.zza((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.zzk().getPackageName();
            byte[] byArray2 = byArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray2);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            this.zza("POST compressed size, ratio %, url", byArray3.length, 100L * (long)byArray3.length / (long)byArray.length, uRL);
            if (byArray3.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray3.length, byArray.length);
            }
            if (zzatf.zzx()) {
                String string = String.valueOf(new String(byArray));
                this.zza("Post payload", (Object)(string.length() != 0 ? "\n".concat(string) : new String("\n")));
            }
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray3.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray3);
            outputStream.close();
            outputStream = null;
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzp().zzh();
            }
            this.zzb("POST status", n);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zza(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.zze("Error closing http connection input stream", iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.zze("Error closing http connection input stream", iOException);
            return;
        }
    }

    private final HttpURLConnection zzb(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(zzast.zzw.zza());
        httpURLConnection.setReadTimeout(zzast.zzx.zza());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zza);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private final URL zza(zzasy zzasy2) {
        String string;
        if (zzasy2.zzf()) {
            String string2 = String.valueOf(zzasl.zzh());
            String string3 = String.valueOf(zzasl.zzj());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            String string4 = String.valueOf(zzasl.zzi());
            String string5 = String.valueOf(zzasl.zzj());
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private final URL zza(zzasy zzasy2, String string) {
        String string2;
        String string3;
        if (zzasy2.zzf()) {
            string3 = zzasl.zzh();
            String string4 = zzasl.zzj();
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append(string3).append(string4).append("?").append(string).toString();
        } else {
            string3 = zzasl.zzi();
            String string5 = zzasl.zzj();
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string5).length() + String.valueOf(string).length()).append(string3).append(string5).append("?").append(string).toString();
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private final URL zzd() {
        String string = String.valueOf(zzasl.zzh());
        String string2 = String.valueOf(zzast.zzn.zza());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    final String zza(zzasy zzasy2, boolean bl) {
        zzbq.zza((Object)zzasy2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzasy2.zzb().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                zzatf.zza(stringBuilder, string, entry.getValue());
            }
            zzatf.zza(stringBuilder, "ht", String.valueOf(zzasy2.zzd()));
            long l = this.zzj().zza() - zzasy2.zzd();
            zzatf.zza(stringBuilder, "qt", String.valueOf(l));
            if (bl) {
                long l2 = zzasy2.zzg();
                String string = l2 != 0L ? String.valueOf(l2) : String.valueOf(zzasy2.zzc());
                zzatf.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private static void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    static /* synthetic */ byte[] zzc() {
        return zzc;
    }
}

