/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbl;
import com.google.android.gms.internal.measurement.zzbu;
import com.google.android.gms.internal.measurement.zzby;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzde;

@SuppressLint(value={"StaticFieldLeak"})
public class zzat {
    private static volatile zzat zzvl;
    private final Context zzqs;
    private final Context zzvm;
    private final Clock zzrj;
    private final zzbu zzvn;
    private final zzcm zzvo;
    private final zzk zzvp;
    private final zzai zzvq;
    private final zzbz zzvr;
    private final zzde zzvs;
    private final zzcq zzvt;
    private final GoogleAnalytics zzvu;
    private final zzbl zzvv;
    private final zzah zzvw;
    private final zzbe zzvx;
    private final zzby zzvy;

    private zzat(zzav zzav2) {
        Context context = zzav2.getApplicationContext();
        Preconditions.checkNotNull((Object)context, (Object)"Application context can't be null");
        Context context2 = zzav2.zzci();
        Preconditions.checkNotNull((Object)context2);
        this.zzqs = context;
        this.zzvm = context2;
        this.zzrj = DefaultClock.getInstance();
        Object object = this;
        this.zzvn = new zzbu((zzat)object);
        object = this;
        zzcm zzcm2 = new zzcm((zzat)object);
        zzcm2.zzm();
        this.zzvo = zzcm2;
        Object object2 = zzas.VERSION;
        this.zzbu().zzs(new StringBuilder(134 + String.valueOf(object2).length()).append("Google Analytics ").append((String)object2).append(" is starting up. To enable debug logging on a device run:\n  adb shell setprop log.tag.GAv4 DEBUG\n  adb logcat -s GAv4").toString());
        object = this;
        object2 = new zzcq((zzat)object);
        ((zzar)object2).zzm();
        this.zzvt = object2;
        object = this;
        zzde zzde2 = new zzde((zzat)object);
        zzde2.zzm();
        this.zzvs = zzde2;
        zzat zzat2 = this;
        object = zzav2;
        zzai zzai2 = new zzai(zzat2, (zzav)object);
        object = this;
        zzbl zzbl2 = new zzbl((zzat)object);
        object = this;
        zzah zzah2 = new zzah((zzat)object);
        object = this;
        zzbe zzbe2 = new zzbe((zzat)object);
        object = this;
        zzby zzby2 = new zzby((zzat)object);
        zzk zzk2 = zzk.zzb(context);
        object = this;
        zzk2.zza(new zzau((zzat)object));
        this.zzvp = zzk2;
        object = this;
        GoogleAnalytics googleAnalytics = new GoogleAnalytics((zzat)object);
        zzbl2.zzm();
        this.zzvv = zzbl2;
        zzah2.zzm();
        this.zzvw = zzah2;
        zzbe2.zzm();
        this.zzvx = zzbe2;
        zzby2.zzm();
        this.zzvy = zzby2;
        object = this;
        zzbz zzbz2 = new zzbz((zzat)object);
        zzbz2.zzm();
        this.zzvr = zzbz2;
        zzai2.zzm();
        this.zzvq = zzai2;
        googleAnalytics.zzm();
        this.zzvu = googleAnalytics;
        zzai2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzat zzc(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzvl != null) return zzvl;
        Class<zzat> clazz = zzat.class;
        synchronized (zzat.class) {
            zzat zzat2;
            if (zzvl != null) return zzvl;
            Clock clock = DefaultClock.getInstance();
            long l = clock.elapsedRealtime();
            zzav zzav2 = new zzav(context);
            zzvl = zzat2 = new zzat(zzav2);
            GoogleAnalytics.zzn();
            long l2 = clock.elapsedRealtime() - l;
            long l3 = zzcc.zzzv.get();
            if (l2 <= l3) return zzvl;
            zzat2.zzbu().zzc("Slow initialization (ms)", l2, l3);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzvl;
        }
    }

    public final Context getContext() {
        return this.zzqs;
    }

    public final Context zzci() {
        return this.zzvm;
    }

    public final Clock zzbt() {
        return this.zzrj;
    }

    public final zzbu zzbv() {
        return this.zzvn;
    }

    public final zzcm zzbu() {
        zzat.zza(this.zzvo);
        return this.zzvo;
    }

    public final zzcm zzcj() {
        return this.zzvo;
    }

    public final zzk zzbw() {
        Preconditions.checkNotNull((Object)this.zzvp);
        return this.zzvp;
    }

    public final zzai zzby() {
        zzat.zza(this.zzvq);
        return this.zzvq;
    }

    public final zzbz zzbz() {
        zzat.zza(this.zzvr);
        return this.zzvr;
    }

    public final GoogleAnalytics zzck() {
        Preconditions.checkNotNull((Object)this.zzvu);
        Preconditions.checkArgument((boolean)this.zzvu.isInitialized(), (Object)"Analytics instance not initialized");
        return this.zzvu;
    }

    public final zzde zzca() {
        zzat.zza(this.zzvs);
        return this.zzvs;
    }

    public final zzcq zzcb() {
        zzat.zza(this.zzvt);
        return this.zzvt;
    }

    public final zzcq zzcl() {
        if (this.zzvt == null || !this.zzvt.isInitialized()) {
            return null;
        }
        return this.zzvt;
    }

    public final zzah zzcm() {
        zzat.zza(this.zzvw);
        return this.zzvw;
    }

    public final zzbl zzcn() {
        zzat.zza(this.zzvv);
        return this.zzvv;
    }

    public final zzbe zzce() {
        zzat.zza(this.zzvx);
        return this.zzvx;
    }

    public final zzby zzcf() {
        return this.zzvy;
    }

    private static void zza(zzar zzar2) {
        Preconditions.checkNotNull((Object)zzar2, (Object)"Analytics service not created/initialized");
        Preconditions.checkArgument((boolean)zzar2.isInitialized(), (Object)"Analytics service not initialized");
    }
}

