/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzat;

class zzcn
extends BroadcastReceiver {
    @VisibleForTesting
    private static final String zzaar = zzcn.class.getName();
    private final zzat zzvi;
    private boolean zzaas;
    private boolean zzaat;

    zzcn(zzat zzat2) {
        Preconditions.checkNotNull((Object)zzat2);
        this.zzvi = zzat2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzeu();
        String string = intent.getAction();
        this.zzvi.zzbu().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzew();
            if (this.zzaat != bl) {
                this.zzaat = bl;
                boolean bl2 = bl;
                zzai zzai2 = this.zzvi.zzby();
                zzai2.zza("Network connectivity status changed", bl2);
                zzai2.zzbw().zza(new zzak(zzai2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzaar)) {
                zzai zzai3 = this.zzvi.zzby();
                zzai3.zzq("Radio powered up");
                zzai3.zzbo();
            }
            return;
        }
        this.zzvi.zzbu().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzet() {
        this.zzeu();
        if (this.zzaas) {
            return;
        }
        Context context = this.zzvi.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzaat = this.zzew();
        this.zzvi.zzbu().zza("Registering connectivity change receiver. Network connected", this.zzaat);
        this.zzaas = true;
    }

    private final void zzeu() {
        this.zzvi.zzbu();
        this.zzvi.zzby();
    }

    public final void unregister() {
        if (!this.zzaas) {
            return;
        }
        this.zzvi.zzbu().zzq("Unregistering connectivity change receiver");
        this.zzaas = false;
        this.zzaat = false;
        Context context = this.zzvi.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzvi.zzbu().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    @VisibleForTesting
    public final void zzev() {
        Context context = this.zzvi.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzaar, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.zzaas) {
            this.zzvi.zzbu().zzt("Connectivity unknown. Receiver not registered");
        }
        return this.zzaat;
    }

    @VisibleForTesting
    private final boolean zzew() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzvi.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

