/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbu;
import com.google.android.gms.internal.measurement.zzbw;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzcz;
import java.util.Collections;
import java.util.List;

@VisibleForTesting
public final class zzax
extends zzar {
    private final zzaz zzwl;
    private zzci zzwm;
    private final zzbw zzwn;
    private final zzcz zzwo;

    protected zzax(zzat zzat2) {
        super(zzat2);
        this.zzwo = new zzcz(zzat2.zzbt());
        this.zzwl = new zzaz(this);
        this.zzwn = new zzay(this, zzat2);
    }

    @Override
    protected final void zzac() {
    }

    public final boolean isConnected() {
        zzk.zzab();
        this.zzch();
        return this.zzwm != null;
    }

    public final boolean zzb(zzch zzch2) {
        Preconditions.checkNotNull((Object)zzch2);
        zzk.zzab();
        this.zzch();
        zzci zzci2 = this.zzwm;
        if (zzci2 == null) {
            return false;
        }
        String string = zzch2.zzep() ? zzbu.zzdz() : zzbu.zzea();
        List<zzbo> list = Collections.emptyList();
        try {
            zzci2.zza(zzch2.zzcs(), zzch2.zzen(), string, list);
            this.zzcu();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzq("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzct() {
        zzk.zzab();
        this.zzch();
        zzci zzci2 = this.zzwm;
        if (zzci2 == null) {
            return false;
        }
        try {
            zzci2.zzbn();
            this.zzcu();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzq("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzcu() {
        this.zzwo.start();
        this.zzwn.zzh(zzcc.zzzu.get());
    }

    public final boolean connect() {
        zzk.zzab();
        this.zzch();
        if (this.zzwm != null) {
            return true;
        }
        zzci zzci2 = this.zzwl.zzcw();
        if (zzci2 != null) {
            this.zzwm = zzci2;
            this.zzcu();
            return true;
        }
        return false;
    }

    private final void zza(zzci zzci2) {
        zzk.zzab();
        this.zzwm = zzci2;
        this.zzcu();
        this.zzby().onServiceConnected();
    }

    public final void disconnect() {
        zzk.zzab();
        this.zzch();
        try {
            ConnectionTracker.getInstance().unbindService(this.getContext(), (ServiceConnection)this.zzwl);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzwm != null) {
            this.zzwm = null;
            this.zzby().zzbq();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzk.zzab();
        if (this.zzwm != null) {
            this.zzwm = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzby().zzbq();
        }
    }

    private final void zzcv() {
        zzk.zzab();
        if (!this.isConnected()) {
            return;
        }
        this.zzq("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzaz zza(zzax zzax2) {
        return zzax2.zzwl;
    }

    static /* synthetic */ void zza(zzax zzax2, zzci zzci2) {
        zzax2.zza(zzci2);
    }

    static /* synthetic */ void zza(zzax zzax2, ComponentName componentName) {
        zzax2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzax zzax2) {
        zzax2.zzcv();
    }
}

