/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzcj;

@VisibleForTesting
public final class zzaz
implements ServiceConnection {
    private volatile zzci zzwq;
    private volatile boolean zzwr;
    final /* synthetic */ zzax zzwp;

    protected zzaz(zzax zzax2) {
        this.zzwp = zzax2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzci zzcw() {
        zzk.zzab();
        Intent intent = new Intent("com.google.android.gms.analytics.service.START");
        intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
        Context context = this.zzwp.getContext();
        intent.putExtra("app_package_name", context.getPackageName());
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzaz zzaz2 = this;
        synchronized (zzaz2) {
            this.zzwq = null;
            this.zzwr = true;
            boolean bl = connectionTracker.bindService(context, intent, (ServiceConnection)zzax.zza(this.zzwp), 129);
            this.zzwp.zza("Bind to service requested", bl);
            if (!bl) {
                this.zzwr = false;
                return null;
            }
            try {
                long l = zzcc.zzzv.get();
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                this.zzwp.zzs("Wait for service connect was interrupted");
            }
            this.zzwr = false;
            zzci zzci2 = this.zzwq;
            this.zzwq = null;
            if (zzci2 == null) {
                this.zzwp.zzt("Successfully bound to service but never got onServiceConnected callback");
            }
            return zzci2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"AnalyticsServiceConnection.onServiceConnected");
        zzaz zzaz2 = this;
        synchronized (zzaz2) {
            try {
                String string;
                if (iBinder == null) {
                    this.zzwp.zzt("Service connected with null binder");
                    return;
                }
                zzci zzci2 = null;
                try {
                    string = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(string)) {
                        IInterface iInterface;
                        IBinder iBinder2 = iBinder;
                        zzci2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.analytics.internal.IAnalyticsService")) instanceof zzci ? (zzci)iInterface : new zzcj(iBinder2));
                        this.zzwp.zzp("Bound to IAnalyticsService interface");
                    } else {
                        this.zzwp.zze("Got binder with a wrong descriptor", string);
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzwp.zzt("Service connect failed to get IAnalyticsService");
                }
                if (zzci2 == null) {
                    try {
                        ConnectionTracker.getInstance().unbindService(this.zzwp.getContext(), (ServiceConnection)zzax.zza(this.zzwp));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (!this.zzwr) {
                    this.zzwp.zzs("onServiceConnected received after the timeout limit");
                    string = zzci2;
                    this.zzwp.zzbw().zza(new zzba(this, (zzci)((Object)string)));
                } else {
                    this.zzwq = zzci2;
                }
            }
            finally {
                this.notifyAll();
            }
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"AnalyticsServiceConnection.onServiceDisconnected");
        this.zzwp.zzbw().zza(new zzbb(this, componentName));
    }
}

