/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzby;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdd;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

@VisibleForTesting
public class Tracker
extends zzar {
    private boolean zzsl;
    private final Map<String, String> zzsm = new HashMap<String, String>();
    private final Map<String, String> zzsn = new HashMap<String, String>();
    private final zzck zzso;
    private final zza zzsp;
    private ExceptionReporter zzsq;
    private zzdc zzsr;

    Tracker(zzat zzat2, String string, zzck zzck2) {
        super(zzat2);
        if (string != null) {
            this.zzsm.put("&tid", string);
        }
        this.zzsm.put("useSecure", "1");
        this.zzsm.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzso = new zzck("tracking", this.zzbt());
        this.zzsp = new zza(zzat2);
    }

    @Override
    protected final void zzac() {
        String string;
        this.zzsp.zzm();
        String string2 = this.zzca().zzaf();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzca().zzag()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzdc zzdc2) {
        String string;
        this.zzq("Loading Tracker config values");
        this.zzsr = zzdc2;
        if (this.zzsr.zzabv != null) {
            string = this.zzsr.zzabv;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzsr.zzabw >= 0.0) {
            string = Double.toString(this.zzsr.zzabw);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzsr.zzabx >= 0) {
            int n = this.zzsr.zzabx;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzsr.zzaby != -1) {
            boolean bl = this.zzsr.zzaby == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzsr.zzabz != -1) {
            boolean bl = this.zzsr.zzabz == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzsr.zzaca == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzsq != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzsq = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzsq);
                this.zzq("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzsq.zzl());
                this.zzq("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzsp.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzsp.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        Preconditions.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzbt().currentTimeMillis();
        if (this.zzbx().getAppOptOut()) {
            this.zzr("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzbx().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zzsm, hashMap);
        Tracker.zza(map, hashMap);
        boolean bl2 = zzdd.zzb(this.zzsm.get("useSecure"), true);
        HashMap<String, String> hashMap2 = hashMap;
        Map<String, String> map2 = this.zzsn;
        Preconditions.checkNotNull(hashMap2);
        if (map2 != null) {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String string = Tracker.zza(entry);
                if (string == null || hashMap2.containsKey(string)) continue;
                hashMap2.put(string, entry.getValue());
            }
        }
        this.zzsn.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzbu().zza(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbu().zza(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzsl;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzsm.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzsm.put("&a", Integer.toString(n));
            }
        }
        this.zzbw().zza(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzch();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzsm.containsKey(string)) {
            return this.zzsm.get(string);
        }
        if (string.equals("&ul")) {
            return zzdd.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzcc().zzdn();
        }
        if (string.equals("&sr")) {
            return this.zzcf().zzeh();
        }
        if (string.equals("&aid")) {
            return this.zzce().zzdb().zzah();
        }
        if (string.equals("&an")) {
            return this.zzce().zzdb().zzaf();
        }
        if (string.equals("&av")) {
            return this.zzce().zzdb().zzag();
        }
        if (string.equals("&aiid")) {
            return this.zzce().zzdb().zzai();
        }
        return null;
    }

    public void set(String string, String string2) {
        Preconditions.checkNotNull((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzsm.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzdd.zzc(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzt("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzdd.zzc(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzsn.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzsn.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzsn.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzsn.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzsn.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzsn.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzsn.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzsn.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzsn.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzsn.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzsl = bl;
    }

    static /* synthetic */ zzah zzb(Tracker tracker) {
        return tracker.zzcd();
    }

    static /* synthetic */ zzbe zzc(Tracker tracker) {
        return tracker.zzce();
    }

    static /* synthetic */ zzby zzd(Tracker tracker) {
        return tracker.zzcf();
    }

    static /* synthetic */ zzby zze(Tracker tracker) {
        return tracker.zzcf();
    }

    static /* synthetic */ zzck zzf(Tracker tracker) {
        return tracker.zzso;
    }

    static /* synthetic */ zzcm zzg(Tracker tracker) {
        return tracker.zzbu();
    }

    static /* synthetic */ zzcm zzh(Tracker tracker) {
        return tracker.zzbu();
    }

    static /* synthetic */ zzai zzi(Tracker tracker) {
        return tracker.zzby();
    }

    static /* synthetic */ zzai zzj(Tracker tracker) {
        return tracker.zzby();
    }

    final class zza
    extends zzar
    implements GoogleAnalytics.zza {
        private boolean zzta;
        private int zztb;
        private long zztc;
        private boolean zztd;
        private long zzte;

        protected zza(zzat zzat2) {
            super(zzat2);
            this.zztc = -1L;
        }

        @Override
        protected final void zzac() {
        }

        public final void setSessionTimeout(long l) {
            this.zztc = l;
            this.zzae();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzta = bl;
            this.zzae();
        }

        public final synchronized boolean zzad() {
            boolean bl = this.zztd;
            this.zztd = false;
            return bl;
        }

        private final void zzae() {
            if (this.zztc >= 0L || this.zzta) {
                this.zzbx().zza(Tracker.this.zzsp);
                return;
            }
            this.zzbx().zzb(Tracker.this.zzsp);
        }

        @Override
        public final void zzc(Activity activity) {
            zza zza2;
            if (this.zztb == 0 && (zza2 = this).zzbt().elapsedRealtime() >= zza2.zzte + Math.max(1000L, zza2.zztc)) {
                this.zztd = true;
            }
            ++this.zztb;
            if (this.zzta) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzsr != null ? ((string2 = ((Tracker)Tracker.this).zzsr.zzacb.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    Preconditions.checkNotNull((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public final void zzd(Activity activity) {
            --this.zztb;
            this.zztb = Math.max(0, this.zztb);
            if (this.zztb == 0) {
                this.zzte = this.zzbt().elapsedRealtime();
            }
        }
    }
}

