/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzdd;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

@VisibleForTesting
public final class zzah
extends zzar {
    private static boolean zzuy;
    private AdvertisingIdClient.Info zzuz;
    private final zzcz zzva;
    private String zzvb;
    private boolean zzvc = false;
    private final Object zzvd = new Object();

    zzah(zzat zzat2) {
        super(zzat2);
        this.zzva = new zzcz(zzat2.zzbt());
    }

    @Override
    protected final void zzac() {
    }

    public final boolean zzbc() {
        this.zzch();
        AdvertisingIdClient.Info info = this.zzbk();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzbj() {
        this.zzch();
        AdvertisingIdClient.Info info = this.zzbk();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzbk() {
        if (this.zzva.zzj(1000L)) {
            this.zzva.start();
            AdvertisingIdClient.Info info = this.zzbl();
            if (this.zza(this.zzuz, info)) {
                this.zzuz = info;
            } else {
                this.zzu("Failed to reset client id on adid change. Not using adid");
                this.zzuz = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzuz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzcc().zzdn();
        Object object = this.zzvd;
        synchronized (object) {
            String string3;
            if (!this.zzvc) {
                this.zzvb = this.zzbm();
                this.zzvc = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzvb)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzp(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzvb = zzah.zzo(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzah.zzo(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzvb)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzvb)) {
                this.zzq("Resetting the client id because Advertising Id changed.");
                string2 = this.zzcc().zzdo();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzp(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzbl() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzt("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Exception exception) {
                if (zzuy) break block3;
                zzuy = true;
                this.zzd("Error getting advertiser id", exception);
            }
        }
        return info;
    }

    private static String zzo(String string) {
        MessageDigest messageDigest = zzdd.getMessageDigest("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzp(String string) {
        try {
            String string2 = zzah.zzo(string);
            this.zzq("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzvb = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzbm() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzt("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzq("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

