/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.HttpUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbu;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzdd;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzbc
extends zzar
implements Closeable {
    private static final String zzwt = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzwu = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zzbd zzwv;
    private final zzcz zzww = new zzcz(this.zzbt());
    private final zzcz zzwx = new zzcz(this.zzbt());

    zzbc(zzat zzat2) {
        super(zzat2);
        String string = "google_analytics_v4.db";
        this.zzwv = new zzbd(this, zzat2.getContext(), string);
    }

    @Override
    protected final void zzac() {
    }

    public final void beginTransaction() {
        this.zzch();
        this.getWritableDatabase().beginTransaction();
    }

    public final void setTransactionSuccessful() {
        this.zzch();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public final void endTransaction() {
        this.zzch();
        this.getWritableDatabase().endTransaction();
    }

    public final void zzc(zzch zzch2) {
        Preconditions.checkNotNull((Object)zzch2);
        zzk.zzab();
        this.zzch();
        Object object2 = zzch2;
        Preconditions.checkNotNull((Object)object2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object3 : ((zzch)object2).zzcs().entrySet()) {
            String l2 = object3.getKey();
            if ("ht".equals(l2) || "qt".equals(l2) || "AppUID".equals(l2)) continue;
            builder.appendQueryParameter(l2, object3.getValue());
        }
        String string = builder.build().getEncodedQuery();
        String string2 = string == null ? "" : string;
        if (string2.length() > 8192) {
            this.zzbu().zza(zzch2, "Hit length exceeds the maximum allowed size");
            return;
        }
        object2 = this;
        int n = zzcc.zzyo.get();
        long l = super.zzcr();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = super.zzc(l2);
            ((zzaq)object2).zzd("Store full, deleting hits to make room, count", list.size());
            ((zzbc)object2).zza(list);
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string2);
        contentValues.put("hit_time", Long.valueOf(zzch2.zzen()));
        contentValues.put("hit_app_id", Integer.valueOf(zzch2.zzel()));
        zzch zzch3 = zzch2;
        contentValues.put("hit_url", zzch3.zzep() ? zzbu.zzdz() : zzbu.zzea());
        try {
            long sQLiteException = sQLiteDatabase.insert("hits2", null, contentValues);
            if (sQLiteException == -1L) {
                this.zzu("Failed to insert a hit (got -1)");
                return;
            }
            this.zzb("Hit saved to database. db-id, hit", sQLiteException, zzch2);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
            return;
        }
    }

    private final long zzcr() {
        zzk.zzab();
        this.zzch();
        return this.zza("SELECT COUNT(*) FROM hits2", null);
    }

    final boolean isEmpty() {
        return this.zzcr() == 0L;
    }

    private final List<Long> zzc(long l) {
        zzk.zzab();
        this.zzch();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public final List<zzch> zzd(long l) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0);
        zzk.zzab();
        this.zzch();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzch> arrayList = new ArrayList<zzch>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzv(string);
                    boolean bl = zzdd.zzah(string2);
                    arrayList.add(new zzch(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzch> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public final void zza(List<Long> list) {
        Long l;
        Preconditions.checkNotNull(list);
        zzk.zzab();
        this.zzch();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public final void zze(long l) {
        zzk.zzab();
        this.zzch();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zza(arrayList);
    }

    public final int zzcx() {
        zzk.zzab();
        this.zzch();
        if (!this.zzww.zzj(86400000L)) {
            return 0;
        }
        this.zzww.start();
        this.zzq("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zzbt().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public final long zzcy() {
        zzk.zzab();
        this.zzch();
        return this.zza(zzwu, null, 0L);
    }

    public final long zza(long l, String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzch();
        zzk.zzab();
        return this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
    }

    public final List<zzaw> zzf(long l) {
        this.zzch();
        zzk.zzab();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = zzcc.zzyq.get();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{"0"};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzaw> arrayList = new ArrayList<zzaw>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzw(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzaw zzaw2 = new zzaw(0L, (String)object, string3, bl, l2, map);
                    arrayList.add(zzaw2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzt("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public final void close() {
        try {
            this.zzwv.close();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
            return;
        }
    }

    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private final long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return 0L;
        }
    }

    @VisibleForTesting
    private final Map<String, String> zzv(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2;
            if (string.startsWith("?")) {
                string2 = string;
            } else {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            String string4 = string2;
            return HttpUtils.parse((URI)new URI(string4), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    @VisibleForTesting
    private final Map<String, String> zzw(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "?".concat(string2) : new String("?");
            return HttpUtils.parse((URI)new URI(string3), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    @VisibleForTesting
    final SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzwv.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private static String zzcz() {
        return "google_analytics_v4.db";
    }

    static /* synthetic */ zzcz zza(zzbc zzbc2) {
        return zzbc2.zzwx;
    }

    static /* synthetic */ String zzb(zzbc zzbc2) {
        return zzbc.zzcz();
    }

    static /* synthetic */ String zzda() {
        return zzwt;
    }
}

