/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbu;
import com.google.android.gms.internal.measurement.zzbw;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzca;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzcn;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.internal.measurement.zzy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzbf
extends zzar {
    private boolean started;
    private final zzbc zzwz;
    private final zzco zzxa;
    private final zzcn zzxb;
    private final zzax zzxc;
    private long zzxd;
    private final zzbw zzxe;
    private final zzbw zzxf;
    private final zzcz zzxg;
    private long zzxh;
    private boolean zzxi;

    protected zzbf(zzat zzat2, zzav zzav2) {
        super(zzat2);
        Preconditions.checkNotNull((Object)zzav2);
        this.zzxd = Long.MIN_VALUE;
        zzat zzat3 = zzat2;
        this.zzxb = new zzcn(zzat3);
        zzat3 = zzat2;
        this.zzwz = new zzbc(zzat3);
        zzat3 = zzat2;
        this.zzxa = new zzco(zzat3);
        zzat3 = zzat2;
        this.zzxc = new zzax(zzat3);
        this.zzxg = new zzcz(this.zzbt());
        this.zzxe = new zzbg(this, zzat2);
        this.zzxf = new zzbh(this, zzat2);
    }

    @Override
    protected final void zzac() {
        this.zzwz.zzm();
        this.zzxa.zzm();
        this.zzxc.zzm();
    }

    final void start() {
        this.zzch();
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.started = true;
        this.zzbw().zza(new zzbi(this));
    }

    private final boolean zzx(String string) {
        return Wrappers.packageManager((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzdc() {
        this.zzch();
        zzbf zzbf2 = this;
        zzk.zzab();
        Context context = zzbf2.zzbs().getContext();
        if (!zzct.zza(context)) {
            zzbf2.zzt("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzcu.zze(context)) {
            zzbf2.zzu("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zza(context)) {
            zzbf2.zzt("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzcb().zzfb();
        if (!this.zzx("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzu("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzdm();
        }
        if (!this.zzx("android.permission.INTERNET")) {
            this.zzu("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzdm();
        }
        if (zzcu.zze(this.getContext())) {
            this.zzq("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzt("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzxi && !this.zzwz.isEmpty()) {
            this.zzdf();
        }
        this.zzdi();
    }

    private final void zzdd() {
        this.zzb(new zzbj(this));
    }

    final void zzbr() {
        zzk.zzab();
        this.zzxh = this.zzbt().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzk.zzab();
        zzbf zzbf2 = this;
        zzk.zzab();
        zzbf2.zzch();
        if (!zzbu.zzdt()) {
            zzbf2.zzt("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzbf2.zzxc.isConnected()) {
            zzbf2.zzq("Service not connected");
            return;
        }
        if (!zzbf2.zzwz.isEmpty()) {
            zzbf2.zzq("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzch> list;
                try {
                    list = zzbf2.zzwz.zzd(zzbu.zzdx());
                    if (list.isEmpty()) {
                        zzbf2.zzdi();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzbf2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzbf2.zzdk();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzch zzch2 = list.get(0);
                    if (!zzbf2.zzxc.zzb(zzch2)) {
                        zzbf2.zzdi();
                        return;
                    }
                    list.remove(zzch2);
                    try {
                        zzbf2.zzwz.zze(zzch2.zzem());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzbf2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzbf2.zzdk();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzde() {
        try {
            this.zzwz.zzcx();
            this.zzdi();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzxf.zzh(86400000L);
    }

    protected final void zzb(zzaw zzaw2) {
        zzk.zzab();
        this.zzb("Sending first hit to property", zzaw2.zzcp());
        if (this.zzcb().zzfc().zzj(zzbu.zzed())) {
            return;
        }
        String string = this.zzcb().zzff();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzv zzv2 = zzdd.zza(this.zzbu(), string);
        this.zzb("Found relevant installation campaign", zzv2);
        this.zza(zzaw2, zzv2);
    }

    public final void zzg(long l) {
        zzk.zzab();
        this.zzch();
        if (l < 0L) {
            l = 0L;
        }
        this.zzxd = l;
        this.zzdi();
    }

    private final void zzdf() {
        if (this.zzxi) {
            return;
        }
        if (!zzbu.zzdt()) {
            return;
        }
        if (this.zzxc.isConnected()) {
            return;
        }
        long l = zzcc.zzzx.get();
        if (this.zzxg.zzj(l)) {
            this.zzxg.start();
            this.zzq("Connecting to service");
            if (this.zzxc.connect()) {
                this.zzq("Connected to service");
                this.zzxg.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzaw zzaw2, boolean bl) {
        long l;
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzch();
        zzk.zzab();
        try {
            this.zzwz.beginTransaction();
            String string = zzaw2.zzaz();
            long l2 = zzaw2.zzco();
            zzbc zzbc2 = this.zzwz;
            Preconditions.checkNotEmpty((String)string);
            zzbc2.zzch();
            zzk.zzab();
            int n = zzbc2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzbc2.zza("Deleted property records", n);
            }
            l = this.zzwz.zza(zzaw2.zzco(), zzaw2.zzaz(), zzaw2.zzcp());
            zzaw2.zzb(l + 1L);
            zzaw zzaw3 = zzaw2;
            zzbc zzbc3 = this.zzwz;
            Preconditions.checkNotNull((Object)zzaw3);
            zzbc3.zzch();
            zzk.zzab();
            SQLiteDatabase sQLiteDatabase = zzbc3.getWritableDatabase();
            Map<String, String> map = zzaw3.zzcs();
            Preconditions.checkNotNull(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzaw3.zzco()));
            contentValues.put("cid", zzaw3.zzaz());
            contentValues.put("tid", zzaw3.zzcp());
            contentValues.put("adid", Integer.valueOf(zzaw3.zzcq() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzaw3.zzcr()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzbc3.zzu("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzbc3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzwz.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzwz.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzch zzch2) {
        zzch zzch3;
        Preconditions.checkNotNull((Object)zzch2);
        zzk.zzab();
        this.zzch();
        if (this.zzxi) {
            this.zzr("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzch2);
        }
        zzch zzch4 = zzch2;
        zzbf zzbf2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzch4.zzer())) {
            zzch3 = zzch4;
        } else {
            Pair<String, Long> pair = zzbf2.zzcb().zzfg().zzfi();
            if (pair == null) {
                zzch3 = zzch4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzch4.zzcs());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzch zzch5 = zzch4;
                zzbf zzbf3 = zzbf2;
                zzch3 = new zzch(zzbf3, (Map<String, String>)object2, zzch5.zzen(), zzch5.zzep(), zzch5.zzem(), zzch5.zzel(), zzch5.zzeo());
            }
        }
        zzch2 = zzch3;
        this.zzdf();
        if (this.zzxc.zzb(zzch2)) {
            this.zzr("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzwz.zzc(zzch2);
            this.zzdi();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzbu().zza(zzch2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzbn() {
        zzk.zzab();
        this.zzch();
        this.zzq("Delete all hits from local store");
        try {
            zzbc zzbc2 = this.zzwz;
            zzk.zzab();
            zzbc2.zzch();
            zzbc2.getWritableDatabase().delete("hits2", null, null);
            zzbc2 = this.zzwz;
            zzk.zzab();
            zzbc2.zzch();
            zzbc2.getWritableDatabase().delete("properties", null, null);
            this.zzdi();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzdf();
        if (this.zzxc.zzct()) {
            this.zzq("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzdg() {
        boolean bl;
        zzk.zzab();
        this.zzch();
        this.zzq("Dispatching a batch of local hits");
        boolean bl2 = !this.zzxc.isConnected();
        boolean bl3 = bl = !this.zzxa.zzex();
        if (bl2 && bl) {
            this.zzq("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzbu.zzdx(), zzbu.zzdy());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzch> list;
                block38: {
                    this.zzwz.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzwz.zzd(l);
                        if (!list.isEmpty()) break block38;
                        this.zzq("Store is empty, nothing to dispatch");
                        this.zzdk();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzdk();
                        try {
                            this.zzwz.setTransactionSuccessful();
                            this.zzwz.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzdk();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzem() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzdk();
                    return false;
                }
                if (this.zzxc.isConnected()) {
                    this.zzq("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzxc.zzb((zzch)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzch)((Object)list2)).zzem());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzwz.zze(((zzch)((Object)list2)).zzem());
                            arrayList.add(((zzch)((Object)list2)).zzem());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzdk();
                            try {
                                this.zzwz.setTransactionSuccessful();
                                this.zzwz.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzdk();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzxa.zzex()) {
                    list2 = this.zzxa.zzb(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzwz.zza(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzdk();
                        try {
                            this.zzwz.setTransactionSuccessful();
                            this.zzwz.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzdk();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzwz.setTransactionSuccessful();
                    this.zzwz.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzdk();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzca zzca2) {
        long l = this.zzxh;
        zzca zzca3 = zzca2;
        zzbf zzbf2 = this;
        zzk.zzab();
        zzbf2.zzch();
        long l2 = -1L;
        long l3 = zzbf2.zzcb().zzfd();
        if (l3 != 0L) {
            l2 = Math.abs(zzbf2.zzbt().currentTimeMillis() - l3);
        }
        zzbf2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzbf2.zzdf();
        try {
            zzbf2.zzdg();
            zzbf2.zzcb().zzfe();
            zzbf2.zzdi();
            if (zzca3 != null) {
                zzca3.zza(null);
            }
            if (zzbf2.zzxh != l) {
                zzbf2.zzxb.zzew();
            }
            return;
        }
        catch (Exception exception) {
            zzbf2.zze("Local dispatch failed", exception);
            zzbf2.zzcb().zzfe();
            zzbf2.zzdi();
            if (zzca3 != null) {
                zzca3.zza(exception);
            }
            return;
        }
    }

    public final void zzdh() {
        zzk.zzab();
        this.zzch();
        this.zzr("Sync dispatching local hits");
        long l = this.zzxh;
        this.zzdf();
        try {
            this.zzdg();
            this.zzcb().zzfe();
            this.zzdi();
            if (this.zzxh != l) {
                this.zzxb.zzew();
            }
            return;
        }
        catch (Exception exception) {
            this.zze("Sync local dispatch failed", exception);
            this.zzdi();
            return;
        }
    }

    private final long zzcy() {
        zzk.zzab();
        this.zzch();
        try {
            return this.zzwz.zzcy();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzdi() {
        boolean bl;
        zzk.zzab();
        this.zzch();
        zzbf zzbf2 = this;
        if (!(!zzbf2.zzxi && zzbf2.zzdl() > 0L)) {
            this.zzxb.unregister();
            this.zzdk();
            return;
        }
        if (this.zzwz.isEmpty()) {
            this.zzxb.unregister();
            this.zzdk();
            return;
        }
        if (!zzcc.zzzs.get().booleanValue()) {
            this.zzxb.zzeu();
            bl = this.zzxb.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzbf2 = this;
            zzbf2.zzdj();
            long l3 = zzbf2.zzdl();
            long l4 = zzbf2.zzcb().zzfd();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzbf2.zzbt().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzbu.zzdv(), l3)) : Math.min(zzbu.zzdv(), l3);
            zzbf2.zza("Dispatch scheduled (ms)", l5);
            if (zzbf2.zzxe.zzef()) {
                l = Math.max(1L, l5 + zzbf2.zzxe.zzee());
                zzbf2.zzxe.zzi(l);
                return;
            }
            zzbf2.zzxe.zzh(l5);
            return;
        }
        this.zzdk();
        this.zzdj();
    }

    private final void zzdj() {
        long l;
        zzbz zzbz2 = this.zzbz();
        if (!zzbz2.zzei()) {
            return;
        }
        if (!zzbz2.zzef() && (l = this.zzcy()) != 0L && Math.abs(this.zzbt().currentTimeMillis() - l) <= zzcc.zzyw.get()) {
            long l2 = zzbu.zzdw();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzbz2.zzej();
        }
    }

    private final void zzdk() {
        zzbf zzbf2 = this;
        if (zzbf2.zzxe.zzef()) {
            zzbf2.zzq("All hits dispatched or no network/service. Going to power save mode");
        }
        zzbf2.zzxe.cancel();
        zzbz zzbz2 = this.zzbz();
        if (zzbz2.zzef()) {
            zzbz2.cancel();
        }
    }

    private final long zzdl() {
        if (this.zzxd != Long.MIN_VALUE) {
            return this.zzxd;
        }
        long l = zzcc.zzyr.get();
        zzde zzde2 = this.zzca();
        zzde2.zzch();
        if (zzde2.zzace) {
            zzde2 = this.zzca();
            zzde2.zzch();
            l = (long)zzde2.zzaag * 1000L;
        }
        return l;
    }

    public final void zzy(String string) {
        Preconditions.checkNotEmpty((String)string);
        zzk.zzab();
        zzv zzv2 = zzdd.zza(this.zzbu(), string);
        if (zzv2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzcb().zzff();
        if (string.equals(string2)) {
            this.zzt("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzcb().zzac(string);
        if (this.zzcb().zzfc().zzj(zzbu.zzed())) {
            this.zzd("Campaign received too late, ignoring", zzv2);
            return;
        }
        this.zzb("Received installation campaign", zzv2);
        for (zzaw zzaw2 : this.zzwz.zzf(0L)) {
            this.zza(zzaw2, zzv2);
        }
    }

    private final void zza(zzaw zzaw2, zzv zzv2) {
        Preconditions.checkNotNull((Object)zzaw2);
        Preconditions.checkNotNull((Object)zzv2);
        zza zza2 = new zza(this.zzbs());
        zza2.zza(zzaw2.zzcp());
        zza2.enableAdvertisingIdCollection(zzaw2.zzcq());
        zzg zzg2 = ((zzj)zza2).zzi();
        zzad zzad2 = zzg2.zzb(zzad.class);
        zzad2.zzl("data");
        zzad2.zzb(true);
        zzg2.zza(zzv2);
        zzy zzy2 = zzg2.zzb(zzy.class);
        zzu zzu2 = zzg2.zzb(zzu.class);
        for (Map.Entry<String, String> entry : zzaw2.zzcs().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzu2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzu2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzu2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzu2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzad2.setUserId(string2);
                continue;
            }
            zzy2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzaw2.zzcp(), zzv2);
        zzg2.zza(this.zzcb().zzfb());
        zzg2.zzs();
    }

    private final void zzdm() {
        this.zzch();
        zzk.zzab();
        this.zzxi = true;
        this.zzxc.disconnect();
        this.zzdi();
    }

    static /* synthetic */ void zza(zzbf zzbf2) {
        zzbf2.zzdd();
    }

    static /* synthetic */ void zzb(zzbf zzbf2) {
        zzbf2.zzde();
    }
}

