/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzat;

class zzcn
extends BroadcastReceiver {
    @VisibleForTesting
    private static final String zzaav = zzcn.class.getName();
    private final zzat zzvm;
    private boolean zzaaw;
    private boolean zzaax;

    zzcn(zzat zzat2) {
        Preconditions.checkNotNull((Object)zzat2);
        this.zzvm = zzat2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzev();
        String string = intent.getAction();
        this.zzvm.zzbu().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzex();
            if (this.zzaax != bl) {
                this.zzaax = bl;
                boolean bl2 = bl;
                zzai zzai2 = this.zzvm.zzby();
                zzai2.zza("Network connectivity status changed", bl2);
                zzai2.zzbw().zza(new zzak(zzai2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzaav)) {
                zzai zzai3 = this.zzvm.zzby();
                zzai3.zzq("Radio powered up");
                zzai3.zzbo();
            }
            return;
        }
        this.zzvm.zzbu().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzeu() {
        this.zzev();
        if (this.zzaaw) {
            return;
        }
        Context context = this.zzvm.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzaax = this.zzex();
        this.zzvm.zzbu().zza("Registering connectivity change receiver. Network connected", this.zzaax);
        this.zzaaw = true;
    }

    private final void zzev() {
        this.zzvm.zzbu();
        this.zzvm.zzby();
    }

    public final void unregister() {
        if (!this.zzaaw) {
            return;
        }
        this.zzvm.zzbu().zzq("Unregistering connectivity change receiver");
        this.zzaaw = false;
        this.zzaax = false;
        Context context = this.zzvm.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzvm.zzbu().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    @VisibleForTesting
    public final void zzew() {
        Context context = this.zzvm.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzaav, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.zzaaw) {
            this.zzvm.zzbu().zzt("Connectivity unknown. Receiver not registered");
        }
        return this.zzaax;
    }

    @VisibleForTesting
    private final boolean zzex() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzvm.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

