/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbp;
import com.google.android.gms.internal.measurement.zzbq;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzbo
extends zzau {
    private volatile String zzup;
    private Future<String> zzyd;

    protected zzbo(zzaw zzaw2) {
        super(zzaw2);
    }

    @Override
    protected final void zzag() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzdr() {
        this.zzcl();
        zzbo zzbo2 = this;
        synchronized (zzbo2) {
            if (this.zzup == null) {
                this.zzyd = this.zzca().zza(new zzbp(this));
            }
            if (this.zzyd != null) {
                try {
                    this.zzup = this.zzyd.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzup = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzup = "0";
                }
                if (this.zzup == null) {
                    this.zzup = "0";
                }
                this.zza("Loaded clientId", this.zzup);
                this.zzyd = null;
            }
            return this.zzup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzds() {
        zzbo zzbo2 = this;
        synchronized (zzbo2) {
            this.zzup = null;
            this.zzyd = this.zzca().zza(new zzbq(this));
        }
        return this.zzdr();
    }

    @VisibleForTesting
    final String zzdt() {
        String string = this.zzd(this.zzca().getContext());
        if (string == null) {
            string = this.zzdu();
        }
        return string;
    }

    @VisibleForTesting
    private final String zzdu() {
        String string = UUID.randomUUID().toString().toLowerCase(Locale.US);
        try {
            if (!this.zzb(this.zzca().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzd(Context context) {
        Preconditions.checkNotMainThread((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzt("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzt("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzb(Context context, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotMainThread((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzbo zzbo2) {
        return zzbo2.zzdu();
    }
}

