/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcn;
import com.google.android.gms.internal.measurement.zzcp;
import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.internal.measurement.zzdg;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

@VisibleForTesting
public class Tracker
extends zzau {
    private boolean zzsx;
    private final Map<String, String> zzsy = new HashMap<String, String>();
    private final Map<String, String> zzsz = new HashMap<String, String>();
    private final zzcn zzta;
    private final zza zztb;
    private ExceptionReporter zztc;
    private zzdf zztd;

    Tracker(zzaw zzaw2, String string, zzcn zzcn2) {
        super(zzaw2);
        if (string != null) {
            this.zzsy.put("&tid", string);
        }
        this.zzsy.put("useSecure", "1");
        this.zzsy.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzta = new zzcn("tracking", this.zzbx());
        this.zztb = new zza(zzaw2);
    }

    @Override
    protected final void zzag() {
        String string;
        this.zztb.zzq();
        String string2 = this.zzce().zzaj();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzce().zzak()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzdf zzdf2) {
        String string;
        this.zzq("Loading Tracker config values");
        this.zztd = zzdf2;
        if (this.zztd.zzaci != null) {
            string = this.zztd.zzaci;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zztd.zzacj >= 0.0) {
            string = Double.toString(this.zztd.zzacj);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zztd.zzack >= 0) {
            int n = this.zztd.zzack;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zztd.zzacl != -1) {
            boolean bl = this.zztd.zzacl == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zztd.zzacm != -1) {
            boolean bl = this.zztd.zzacm == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zztd.zzacn == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zztc != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zztc = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zztc);
                this.zzq("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zztc.zzp());
                this.zzq("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zztb.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zztb.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        Preconditions.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzbx().currentTimeMillis();
        if (this.zzcb().getAppOptOut()) {
            this.zzr("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzcb().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zzsy, hashMap);
        Tracker.zza(map, hashMap);
        boolean bl2 = zzdg.zzb(this.zzsy.get("useSecure"), true);
        HashMap<String, String> hashMap2 = hashMap;
        Map<String, String> map2 = this.zzsz;
        Preconditions.checkNotNull(hashMap2);
        if (map2 != null) {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String string = Tracker.zza(entry);
                if (string == null || hashMap2.containsKey(string)) continue;
                hashMap2.put(string, entry.getValue());
            }
        }
        this.zzsz.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzby().zza(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzby().zza(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzsx;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzsy.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzsy.put("&a", Integer.toString(n));
            }
        }
        this.zzca().zza(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzcl();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzsy.containsKey(string)) {
            return this.zzsy.get(string);
        }
        if (string.equals("&ul")) {
            return zzdg.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzcg().zzdr();
        }
        if (string.equals("&sr")) {
            return this.zzcj().zzel();
        }
        if (string.equals("&aid")) {
            return this.zzci().zzdf().zzal();
        }
        if (string.equals("&an")) {
            return this.zzci().zzdf().zzaj();
        }
        if (string.equals("&av")) {
            return this.zzci().zzdf().zzak();
        }
        if (string.equals("&aiid")) {
            return this.zzci().zzdf().zzam();
        }
        return null;
    }

    public void set(String string, String string2) {
        Preconditions.checkNotNull((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzsy.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzdg.zzc(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzt("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzdg.zzc(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzsz.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzsz.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzsz.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzsz.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzsz.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzsz.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzsz.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzsz.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzsz.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzsz.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzsx = bl;
    }

    static /* synthetic */ zzak zzb(Tracker tracker) {
        return tracker.zzch();
    }

    static /* synthetic */ zzbh zzc(Tracker tracker) {
        return tracker.zzci();
    }

    static /* synthetic */ zzcb zzd(Tracker tracker) {
        return tracker.zzcj();
    }

    static /* synthetic */ zzcb zze(Tracker tracker) {
        return tracker.zzcj();
    }

    static /* synthetic */ zzcn zzf(Tracker tracker) {
        return tracker.zzta;
    }

    static /* synthetic */ zzcp zzg(Tracker tracker) {
        return tracker.zzby();
    }

    static /* synthetic */ zzcp zzh(Tracker tracker) {
        return tracker.zzby();
    }

    static /* synthetic */ zzal zzi(Tracker tracker) {
        return tracker.zzcc();
    }

    static /* synthetic */ zzal zzj(Tracker tracker) {
        return tracker.zzcc();
    }

    final class zza
    extends zzau
    implements GoogleAnalytics.zza {
        private boolean zztm;
        private int zztn;
        private long zzto;
        private boolean zztp;
        private long zztq;

        protected zza(zzaw zzaw2) {
            super(zzaw2);
            this.zzto = -1L;
        }

        @Override
        protected final void zzag() {
        }

        public final void setSessionTimeout(long l) {
            this.zzto = l;
            this.zzai();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zztm = bl;
            this.zzai();
        }

        public final synchronized boolean zzah() {
            boolean bl = this.zztp;
            this.zztp = false;
            return bl;
        }

        private final void zzai() {
            if (this.zzto >= 0L || this.zztm) {
                this.zzcb().zza(Tracker.this.zztb);
                return;
            }
            this.zzcb().zzb(Tracker.this.zztb);
        }

        @Override
        public final void zzc(Activity activity) {
            zza zza2;
            if (this.zztn == 0 && (zza2 = this).zzbx().elapsedRealtime() >= zza2.zztq + Math.max(1000L, zza2.zzto)) {
                this.zztp = true;
            }
            ++this.zztn;
            if (this.zztm) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zztd != null ? ((string2 = ((Tracker)Tracker.this).zztd.zzaco.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    Preconditions.checkNotNull((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public final void zzd(Activity activity) {
            --this.zztn;
            this.zztn = Math.max(0, this.zztn);
            if (this.zztn == 0) {
                this.zztq = this.zzbx().elapsedRealtime();
            }
        }
    }
}

