/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.HttpUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdg;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzbf
extends zzau
implements Closeable {
    private static final String zzxf = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzxg = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zzbg zzxh;
    private final zzdc zzxi = new zzdc(this.zzbx());
    private final zzdc zzxj = new zzdc(this.zzbx());

    zzbf(zzaw zzaw2) {
        super(zzaw2);
        String string = "google_analytics_v4.db";
        this.zzxh = new zzbg(this, zzaw2.getContext(), string);
    }

    @Override
    protected final void zzag() {
    }

    public final void beginTransaction() {
        this.zzcl();
        this.getWritableDatabase().beginTransaction();
    }

    public final void setTransactionSuccessful() {
        this.zzcl();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public final void endTransaction() {
        this.zzcl();
        this.getWritableDatabase().endTransaction();
    }

    public final void zzc(zzck zzck2) {
        Preconditions.checkNotNull((Object)zzck2);
        zzk.zzaf();
        this.zzcl();
        Object object2 = zzck2;
        Preconditions.checkNotNull((Object)object2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object3 : ((zzck)object2).zzcw().entrySet()) {
            String l2 = object3.getKey();
            if ("ht".equals(l2) || "qt".equals(l2) || "AppUID".equals(l2)) continue;
            builder.appendQueryParameter(l2, object3.getValue());
        }
        String string = builder.build().getEncodedQuery();
        String string2 = string == null ? "" : string;
        if (string2.length() > 8192) {
            this.zzby().zza(zzck2, "Hit length exceeds the maximum allowed size");
            return;
        }
        object2 = this;
        int n = zzcf.zzza.get();
        long l = super.zzcv();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = super.zzc(l2);
            ((zzat)object2).zzd("Store full, deleting hits to make room, count", list.size());
            ((zzbf)object2).zza(list);
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string2);
        contentValues.put("hit_time", Long.valueOf(zzck2.zzer()));
        contentValues.put("hit_app_id", Integer.valueOf(zzck2.zzep()));
        zzck zzck3 = zzck2;
        contentValues.put("hit_url", zzck3.zzet() ? zzbx.zzed() : zzbx.zzee());
        try {
            long sQLiteException = sQLiteDatabase.insert("hits2", null, contentValues);
            if (sQLiteException == -1L) {
                this.zzu("Failed to insert a hit (got -1)");
                return;
            }
            this.zzb("Hit saved to database. db-id, hit", sQLiteException, zzck2);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
            return;
        }
    }

    private final long zzcv() {
        zzk.zzaf();
        this.zzcl();
        return this.zza("SELECT COUNT(*) FROM hits2", null);
    }

    final boolean isEmpty() {
        return this.zzcv() == 0L;
    }

    private final List<Long> zzc(long l) {
        zzk.zzaf();
        this.zzcl();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public final List<zzck> zzd(long l) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0);
        zzk.zzaf();
        this.zzcl();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzck> arrayList = new ArrayList<zzck>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzv(string);
                    boolean bl = zzdg.zzah(string2);
                    arrayList.add(new zzck(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzck> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public final void zza(List<Long> list) {
        Long l;
        Preconditions.checkNotNull(list);
        zzk.zzaf();
        this.zzcl();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public final void zze(long l) {
        zzk.zzaf();
        this.zzcl();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zza(arrayList);
    }

    public final int zzdb() {
        zzk.zzaf();
        this.zzcl();
        if (!this.zzxi.zzj(86400000L)) {
            return 0;
        }
        this.zzxi.start();
        this.zzq("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zzbx().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public final long zzdc() {
        zzk.zzaf();
        this.zzcl();
        return this.zza(zzxg, null, 0L);
    }

    public final long zza(long l, String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzcl();
        zzk.zzaf();
        return this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
    }

    public final List<zzaz> zzf(long l) {
        this.zzcl();
        zzk.zzaf();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = zzcf.zzzc.get();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{"0"};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzaz> arrayList = new ArrayList<zzaz>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzw(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzaz zzaz2 = new zzaz(0L, (String)object, string3, bl, l2, map);
                    arrayList.add(zzaz2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzt("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public final void close() {
        try {
            this.zzxh.close();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
            return;
        }
    }

    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private final long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return 0L;
        }
    }

    @VisibleForTesting
    private final Map<String, String> zzv(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2;
            if (string.startsWith("?")) {
                string2 = string;
            } else {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            String string4 = string2;
            return HttpUtils.parse((URI)new URI(string4), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    @VisibleForTesting
    private final Map<String, String> zzw(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "?".concat(string2) : new String("?");
            return HttpUtils.parse((URI)new URI(string3), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    @VisibleForTesting
    final SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzxh.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private static String zzdd() {
        return "google_analytics_v4.db";
    }

    static /* synthetic */ zzdc zza(zzbf zzbf2) {
        return zzbf2.zzxj;
    }

    static /* synthetic */ String zzb(zzbf zzbf2) {
        return zzbf.zzdd();
    }

    static /* synthetic */ String zzde() {
        return zzxf;
    }
}

