/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzcf;

public final class zzcc
extends zzau {
    private boolean zzyr;
    private boolean zzys;
    private final AlarmManager zzyt = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzyu;

    protected zzcc(zzaw zzaw2) {
        super(zzaw2);
    }

    @Override
    protected final void zzag() {
        try {
            ActivityInfo activityInfo;
            this.cancel();
            if (zzbx.zzea() > 0L && (activityInfo = this.getContext().getPackageManager().getReceiverInfo(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"), 2)) != null && activityInfo.enabled) {
                this.zzq("Receiver registered for local dispatch.");
                this.zzyr = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzem() {
        return this.zzyr;
    }

    public final boolean zzej() {
        return this.zzys;
    }

    public final void zzen() {
        this.zzcl();
        Preconditions.checkState((boolean)this.zzyr, (Object)"Receiver not registered");
        long l = zzbx.zzea();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzbx().elapsedRealtime() + l;
            this.zzys = true;
            zzcf.zzaam.get().booleanValue();
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzq("Scheduling upload with JobScheduler");
                long l3 = l;
                zzcc zzcc2 = this;
                ComponentName componentName = new ComponentName(zzcc2.getContext(), "com.google.android.gms.analytics.AnalyticsJobService");
                JobScheduler jobScheduler = (JobScheduler)zzcc2.getContext().getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(zzcc2.getJobId(), componentName);
                builder.setMinimumLatency(l3);
                builder.setOverrideDeadline(l3 << 1);
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                builder.setExtras(persistableBundle);
                JobInfo jobInfo = builder.build();
                zzcc2.zza("Scheduling job. JobID", zzcc2.getJobId());
                jobScheduler.schedule(jobInfo);
                return;
            }
            this.zzq("Scheduling upload with AlarmManager");
            this.zzyt.setInexactRepeating(2, l2, l, this.zzeo());
        }
    }

    private final PendingIntent zzeo() {
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzys = false;
        this.zzyt.cancel(this.zzeo());
        if (Build.VERSION.SDK_INT >= 24) {
            zzcc zzcc2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzcc2.getContext().getSystemService("jobscheduler");
            zzcc2.zza("Cancelling job. JobID", zzcc2.getJobId());
            jobScheduler.cancel(zzcc2.getJobId());
        }
    }

    private final int getJobId() {
        if (this.zzyu == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyu = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzyu;
    }
}

