/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

@VisibleForTesting
public class StandardExceptionParser
implements ExceptionParser {
    private final TreeSet<String> zzsw = new TreeSet();

    public StandardExceptionParser(Context context, Collection<String> collection) {
        this.setIncludedPackages(context, collection);
    }

    public void setIncludedPackages(Context context, Collection<String> collection) {
        this.zzsw.clear();
        HashSet<String> hashSet = new HashSet<String>();
        if (collection != null) {
            hashSet.addAll(collection);
        }
        if (context != null) {
            hashSet.add(context.getApplicationContext().getPackageName());
        }
        for (String string : hashSet) {
            boolean bl = true;
            for (String string2 : this.zzsw) {
                if (!string.startsWith(string2)) {
                    if (!string2.startsWith(string)) break;
                    this.zzsw.remove(string2);
                    break;
                }
                bl = false;
            }
            if (!bl) continue;
            this.zzsw.add(string);
        }
    }

    protected Throwable getCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    protected StackTraceElement getBestStackTraceElement(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            String string = stackTraceElement.getClassName();
            for (String string2 : this.zzsw) {
                if (!string.startsWith(string2)) continue;
                return stackTraceElement;
            }
        }
        return stackTraceElementArray[0];
    }

    protected String getDescription(Throwable throwable, StackTraceElement stackTraceElement, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.getClass().getSimpleName());
        if (stackTraceElement != null) {
            String[] stringArray = stackTraceElement.getClassName().split("\\.");
            String string2 = "unknown";
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[stringArray.length - 1];
            }
            stringBuilder.append(String.format(" (@%s:%s:%s)", string2, stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
        }
        if (string != null) {
            stringBuilder.append(String.format(" {%s}", string));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDescription(String string, Throwable throwable) {
        return this.getDescription(this.getCause(throwable), this.getBestStackTraceElement(this.getCause(throwable)), string);
    }
}

