/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzaw;

class zzcq
extends BroadcastReceiver {
    @VisibleForTesting
    private static final String zzabi = zzcq.class.getName();
    private final zzaw zzvy;
    private boolean zzabj;
    private boolean zzabk;

    zzcq(zzaw zzaw2) {
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzvy = zzaw2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzez();
        String string = intent.getAction();
        this.zzvy.zzby().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzfb();
            if (this.zzabk != bl) {
                this.zzabk = bl;
                boolean bl2 = bl;
                zzal zzal2 = this.zzvy.zzcc();
                zzal2.zza("Network connectivity status changed", bl2);
                zzal2.zzca().zza(new zzan(zzal2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzabi)) {
                zzal zzal3 = this.zzvy.zzcc();
                zzal3.zzq("Radio powered up");
                zzal3.zzbs();
            }
            return;
        }
        this.zzvy.zzby().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzey() {
        this.zzez();
        if (this.zzabj) {
            return;
        }
        Context context = this.zzvy.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzabk = this.zzfb();
        this.zzvy.zzby().zza("Registering connectivity change receiver. Network connected", this.zzabk);
        this.zzabj = true;
    }

    private final void zzez() {
        this.zzvy.zzby();
        this.zzvy.zzcc();
    }

    public final void unregister() {
        if (!this.zzabj) {
            return;
        }
        this.zzvy.zzby().zzq("Unregistering connectivity change receiver");
        this.zzabj = false;
        this.zzabk = false;
        Context context = this.zzvy.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzvy.zzby().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    @VisibleForTesting
    public final void zzfa() {
        Context context = this.zzvy.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzabi, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.zzabj) {
            this.zzvy.zzby().zzt("Connectivity unknown. Receiver not registered");
        }
        return this.zzabk;
    }

    @VisibleForTesting
    private final boolean zzfb() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzvy.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

