/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzdg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@VisibleForTesting
public class HitBuilders {
    public HitBuilders() {
    }

    @VisibleForTesting
    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        public ItemBuilder() {
            this.set("&t", "item");
        }

        public ItemBuilder setTransactionId(String string) {
            this.set("&ti", string);
            return this;
        }

        public ItemBuilder setName(String string) {
            this.set("&in", string);
            return this;
        }

        public ItemBuilder setSku(String string) {
            this.set("&ic", string);
            return this;
        }

        public ItemBuilder setCategory(String string) {
            this.set("&iv", string);
            return this;
        }

        public ItemBuilder setPrice(double d) {
            this.set("&ip", Double.toString(d));
            return this;
        }

        public ItemBuilder setQuantity(long l) {
            this.set("&iq", Long.toString(l));
            return this;
        }

        public ItemBuilder setCurrencyCode(String string) {
            this.set("&cu", string);
            return this;
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        public TransactionBuilder() {
            this.set("&t", "transaction");
        }

        public TransactionBuilder setTransactionId(String string) {
            this.set("&ti", string);
            return this;
        }

        public TransactionBuilder setAffiliation(String string) {
            this.set("&ta", string);
            return this;
        }

        public TransactionBuilder setRevenue(double d) {
            this.set("&tr", Double.toString(d));
            return this;
        }

        public TransactionBuilder setTax(double d) {
            this.set("&tt", Double.toString(d));
            return this;
        }

        public TransactionBuilder setShipping(double d) {
            this.set("&ts", Double.toString(d));
            return this;
        }

        public TransactionBuilder setCurrencyCode(String string) {
            this.set("&cu", string);
            return this;
        }
    }

    @VisibleForTesting
    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        public ExceptionBuilder() {
            this.set("&t", "exception");
        }

        public ExceptionBuilder setDescription(String string) {
            this.set("&exd", string);
            return this;
        }

        public ExceptionBuilder setFatal(boolean bl) {
            this.set("&exf", zzdg.zzc(bl));
            return this;
        }
    }

    @VisibleForTesting
    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        public TimingBuilder() {
            this.set("&t", "timing");
        }

        public TimingBuilder(String string, String string2, long l) {
            this();
            this.setVariable(string2);
            this.setValue(l);
            this.setCategory(string);
        }

        public TimingBuilder setVariable(String string) {
            this.set("&utv", string);
            return this;
        }

        public TimingBuilder setValue(long l) {
            this.set("&utt", Long.toString(l));
            return this;
        }

        public TimingBuilder setCategory(String string) {
            this.set("&utc", string);
            return this;
        }

        public TimingBuilder setLabel(String string) {
            this.set("&utl", string);
            return this;
        }
    }

    @VisibleForTesting
    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        public SocialBuilder() {
            this.set("&t", "social");
        }

        public SocialBuilder setNetwork(String string) {
            this.set("&sn", string);
            return this;
        }

        public SocialBuilder setAction(String string) {
            this.set("&sa", string);
            return this;
        }

        public SocialBuilder setTarget(String string) {
            this.set("&st", string);
            return this;
        }
    }

    @VisibleForTesting
    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        public EventBuilder() {
            this.set("&t", "event");
        }

        public EventBuilder(String string, String string2) {
            this();
            this.setCategory(string);
            this.setAction(string2);
        }

        public EventBuilder setCategory(String string) {
            this.set("&ec", string);
            return this;
        }

        public EventBuilder setAction(String string) {
            this.set("&ea", string);
            return this;
        }

        public EventBuilder setLabel(String string) {
            this.set("&el", string);
            return this;
        }

        public EventBuilder setValue(long l) {
            this.set("&ev", Long.toString(l));
            return this;
        }
    }

    @VisibleForTesting
    public static class HitBuilder<T extends HitBuilder> {
        private Map<String, String> map = new HashMap<String, String>();
        private ProductAction zzrt;
        private Map<String, List<Product>> zzru = new HashMap<String, List<Product>>();
        private List<Promotion> zzrv = new ArrayList<Promotion>();
        private List<Product> zzrw = new ArrayList<Product>();

        protected HitBuilder() {
        }

        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        public T setNonInteraction(boolean bl) {
            this.set("&ni", zzdg.zzc(bl));
            return (T)this;
        }

        public T setCampaignParamsFromUrl(String string) {
            String string2 = zzdg.zzag(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return (T)this;
            }
            Map<String, String> map = zzdg.zzae(string2);
            this.zza("&cc", map.get("utm_content"));
            this.zza("&cm", map.get("utm_medium"));
            this.zza("&cn", map.get("utm_campaign"));
            this.zza("&cs", map.get("utm_source"));
            this.zza("&ck", map.get("utm_term"));
            this.zza("&ci", map.get("utm_id"));
            this.zza("&anid", map.get("anid"));
            this.zza("&gclid", map.get("gclid"));
            this.zza("&dclid", map.get("dclid"));
            this.zza("&aclid", map.get("aclid"));
            this.zza("&gmob_t", map.get("gmob_t"));
            return (T)this;
        }

        public T setCustomDimension(int n, String string) {
            this.set(zzd.zzd(n), string);
            return (T)this;
        }

        public T setCustomMetric(int n, float f) {
            this.set(zzd.zzf(n), Float.toString(f));
            return (T)this;
        }

        public final T set(String string, String string2) {
            if (string != null) {
                this.map.put(string, string2);
            } else {
                zzco.zzab("HitBuilder.set() called with a null paramName.");
            }
            return (T)this;
        }

        private final T zza(String string, String string2) {
            if (string2 != null) {
                this.map.put(string, string2);
            }
            return (T)this;
        }

        public final T setAll(Map<String, String> map) {
            if (map == null) {
                return (T)this;
            }
            this.map.putAll(new HashMap<String, String>(map));
            return (T)this;
        }

        public Map<String, String> build() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.map);
            if (this.zzrt != null) {
                hashMap.putAll(this.zzrt.build());
            }
            int n = 1;
            for (Promotion object : this.zzrv) {
                hashMap.putAll(object.zzn(zzd.zzj(n)));
                ++n;
            }
            n = 1;
            for (Product product : this.zzrw) {
                hashMap.putAll(product.zzn(zzd.zzh(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry entry : this.zzru.entrySet()) {
                List list = (List)entry.getValue();
                String string = zzd.zzm(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzl(n2));
                    hashMap.putAll(product.zzn(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), (String)entry.getKey());
                }
                ++n;
            }
            return hashMap;
        }

        public T setProductAction(ProductAction productAction) {
            this.zzrt = productAction;
            return (T)this;
        }

        public T addImpression(Product product, String string) {
            if (product == null) {
                zzco.zzab("product should be non-null");
                return (T)this;
            }
            if (string == null) {
                string = "";
            }
            if (!this.zzru.containsKey(string)) {
                this.zzru.put(string, new ArrayList());
            }
            this.zzru.get(string).add(product);
            return (T)this;
        }

        public T addPromotion(Promotion promotion) {
            if (promotion == null) {
                zzco.zzab("promotion should be non-null");
                return (T)this;
            }
            this.zzrv.add(promotion);
            return (T)this;
        }

        public T setPromotionAction(String string) {
            this.map.put("&promoa", string);
            return (T)this;
        }

        public T addProduct(Product product) {
            if (product == null) {
                zzco.zzab("product should be non-null");
                return (T)this;
            }
            this.zzrw.add(product);
            return (T)this;
        }

        protected T setHitType(String string) {
            this.set("&t", string);
            return (T)this;
        }

        @VisibleForTesting
        protected String get(String string) {
            return this.map.get(string);
        }
    }
}

