/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzad;
import com.google.android.gms.internal.gtm.zzae;
import com.google.android.gms.internal.gtm.zzan;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzba;
import com.google.android.gms.internal.gtm.zzbu;
import com.google.android.gms.internal.gtm.zzcg;
import com.google.android.gms.internal.gtm.zzci;
import com.google.android.gms.internal.gtm.zzcy;
import com.google.android.gms.internal.gtm.zzcz;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

@VisibleForTesting
public class Tracker
extends zzan {
    private boolean zztb;
    private final Map<String, String> zztc = new HashMap<String, String>();
    private final Map<String, String> zztd = new HashMap<String, String>();
    private final zzcg zzte;
    private final zza zztf;
    private ExceptionReporter zztg;
    private zzcy zzth;

    Tracker(zzap zzap2, String string, zzcg zzcg2) {
        super(zzap2);
        if (string != null) {
            this.zztc.put("&tid", string);
        }
        this.zztc.put("useSecure", "1");
        this.zztc.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzte = new zzcg("tracking", this.zzcn());
        this.zztf = new zza(zzap2);
    }

    @Override
    protected final void zzaw() {
        String string;
        this.zztf.zzag();
        String string2 = this.zzcu().zzaz();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzcu().zzba()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzcy zzcy2) {
        String string;
        this.zzq("Loading Tracker config values");
        this.zzth = zzcy2;
        if (this.zzth.zzacm != null) {
            string = this.zzth.zzacm;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzth.zzacn >= 0.0) {
            string = Double.toString(this.zzth.zzacn);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzth.zzaco >= 0) {
            int n = this.zzth.zzaco;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzth.zzacp != -1) {
            boolean bl = this.zzth.zzacp == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzth.zzacq != -1) {
            boolean bl = this.zzth.zzacq == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzth.zzacr == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zztg != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zztg = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zztg);
                this.zzq("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zztg.zzaf());
                this.zzq("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zztf.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zztf.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        Preconditions.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzcn().currentTimeMillis();
        if (this.zzcr().getAppOptOut()) {
            this.zzr("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzcr().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zztc, hashMap);
        Tracker.zza(map, hashMap);
        boolean bl2 = zzcz.zzb(this.zztc.get("useSecure"), true);
        HashMap<String, String> hashMap2 = hashMap;
        Map<String, String> map2 = this.zztd;
        Preconditions.checkNotNull(hashMap2);
        if (map2 != null) {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String string = Tracker.zza(entry);
                if (string == null || hashMap2.containsKey(string)) continue;
                hashMap2.put(string, entry.getValue());
            }
        }
        this.zztd.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzco().zza(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzco().zza(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zztb;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zztc.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zztc.put("&a", Integer.toString(n));
            }
        }
        this.zzcq().zza(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzdb();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zztc.containsKey(string)) {
            return this.zztc.get(string);
        }
        if (string.equals("&ul")) {
            return zzcz.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzcw().zzeh();
        }
        if (string.equals("&sr")) {
            return this.zzcz().zzfb();
        }
        if (string.equals("&aid")) {
            return this.zzcy().zzdv().zzbb();
        }
        if (string.equals("&an")) {
            return this.zzcy().zzdv().zzaz();
        }
        if (string.equals("&av")) {
            return this.zzcy().zzdv().zzba();
        }
        if (string.equals("&aiid")) {
            return this.zzcy().zzdv().zzbc();
        }
        return null;
    }

    public void set(String string, String string2) {
        Preconditions.checkNotNull((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zztc.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzcz.zzc(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzt("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzcz.zzc(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zztd.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zztd.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zztd.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zztd.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zztd.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zztd.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zztd.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zztd.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zztd.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zztd.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zztb = bl;
    }

    static /* synthetic */ zzad zzb(Tracker tracker) {
        return tracker.zzcx();
    }

    static /* synthetic */ zzba zzc(Tracker tracker) {
        return tracker.zzcy();
    }

    static /* synthetic */ zzbu zzd(Tracker tracker) {
        return tracker.zzcz();
    }

    static /* synthetic */ zzbu zze(Tracker tracker) {
        return tracker.zzcz();
    }

    static /* synthetic */ zzcg zzf(Tracker tracker) {
        return tracker.zzte;
    }

    static /* synthetic */ zzci zzg(Tracker tracker) {
        return tracker.zzco();
    }

    static /* synthetic */ zzci zzh(Tracker tracker) {
        return tracker.zzco();
    }

    static /* synthetic */ zzae zzi(Tracker tracker) {
        return tracker.zzcs();
    }

    static /* synthetic */ zzae zzj(Tracker tracker) {
        return tracker.zzcs();
    }

    final class zza
    extends zzan
    implements GoogleAnalytics.zza {
        private boolean zztq;
        private int zztr;
        private long zzts;
        private boolean zztt;
        private long zztu;

        protected zza(zzap zzap2) {
            super(zzap2);
            this.zzts = -1L;
        }

        @Override
        protected final void zzaw() {
        }

        public final void setSessionTimeout(long l) {
            this.zzts = l;
            this.zzay();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zztq = bl;
            this.zzay();
        }

        public final synchronized boolean zzax() {
            boolean bl = this.zztt;
            this.zztt = false;
            return bl;
        }

        private final void zzay() {
            if (this.zzts >= 0L || this.zztq) {
                this.zzcr().zza(Tracker.this.zztf);
                return;
            }
            this.zzcr().zzb(Tracker.this.zztf);
        }

        @Override
        public final void zzc(Activity activity) {
            zza zza2;
            if (this.zztr == 0 && (zza2 = this).zzcn().elapsedRealtime() >= zza2.zztu + Math.max(1000L, zza2.zzts)) {
                this.zztt = true;
            }
            ++this.zztr;
            if (this.zztq) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzth != null ? ((string2 = ((Tracker)Tracker.this).zzth.zzacs.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    Preconditions.checkNotNull((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public final void zzd(Activity activity) {
            --this.zztr;
            this.zztr = Math.max(0, this.zztr);
            if (this.zztr == 0) {
                this.zztu = this.zzcn().elapsedRealtime();
            }
        }
    }
}

