/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzan;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzau;
import com.google.android.gms.internal.gtm.zzav;
import com.google.android.gms.internal.gtm.zzbk;
import com.google.android.gms.internal.gtm.zzbq;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzby;
import com.google.android.gms.internal.gtm.zzcd;
import com.google.android.gms.internal.gtm.zzce;
import com.google.android.gms.internal.gtm.zzcv;
import java.util.Collections;
import java.util.List;

@VisibleForTesting
public final class zzat
extends zzan {
    private final zzav zzxa;
    private zzce zzxb;
    private final zzbs zzxc;
    private final zzcv zzxd;

    protected zzat(zzap zzap2) {
        super(zzap2);
        this.zzxd = new zzcv(zzap2.zzcn());
        this.zzxa = new zzav(this);
        this.zzxc = new zzau(this, zzap2);
    }

    @Override
    protected final void zzaw() {
    }

    public final boolean isConnected() {
        zzk.zzav();
        this.zzdb();
        return this.zzxb != null;
    }

    public final boolean zzb(zzcd zzcd2) {
        Preconditions.checkNotNull((Object)zzcd2);
        zzk.zzav();
        this.zzdb();
        zzce zzce2 = this.zzxb;
        if (zzce2 == null) {
            return false;
        }
        String string = zzcd2.zzfj() ? zzbq.zzet() : zzbq.zzeu();
        List<zzbk> list = Collections.emptyList();
        try {
            zzce2.zza(zzcd2.zzdm(), zzcd2.zzfh(), string, list);
            this.zzdo();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzq("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzdn() {
        zzk.zzav();
        this.zzdb();
        zzce zzce2 = this.zzxb;
        if (zzce2 == null) {
            return false;
        }
        try {
            zzce2.zzch();
            this.zzdo();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzq("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzdo() {
        this.zzxd.start();
        this.zzxc.zzh(zzby.zzaaj.get());
    }

    public final boolean connect() {
        zzk.zzav();
        this.zzdb();
        if (this.zzxb != null) {
            return true;
        }
        zzce zzce2 = this.zzxa.zzdq();
        if (zzce2 != null) {
            this.zzxb = zzce2;
            this.zzdo();
            return true;
        }
        return false;
    }

    private final void zza(zzce zzce2) {
        zzk.zzav();
        this.zzxb = zzce2;
        this.zzdo();
        this.zzcs().onServiceConnected();
    }

    public final void disconnect() {
        zzk.zzav();
        this.zzdb();
        try {
            ConnectionTracker.getInstance().unbindService(this.getContext(), (ServiceConnection)this.zzxa);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzxb != null) {
            this.zzxb = null;
            this.zzcs().zzck();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzk.zzav();
        if (this.zzxb != null) {
            this.zzxb = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzcs().zzck();
        }
    }

    private final void zzdp() {
        zzk.zzav();
        if (!this.isConnected()) {
            return;
        }
        this.zzq("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzav zza(zzat zzat2) {
        return zzat2.zzxa;
    }

    static /* synthetic */ void zza(zzat zzat2, zzce zzce2) {
        zzat2.zza(zzce2);
    }

    static /* synthetic */ void zza(zzat zzat2, ComponentName componentName) {
        zzat2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzat zzat2) {
        zzat2.zzdp();
    }
}

