/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzat;
import com.google.android.gms.internal.gtm.zzaw;
import com.google.android.gms.internal.gtm.zzax;
import com.google.android.gms.internal.gtm.zzby;
import com.google.android.gms.internal.gtm.zzce;
import com.google.android.gms.internal.gtm.zzcf;

@VisibleForTesting
public final class zzav
implements ServiceConnection {
    private volatile zzce zzxf;
    private volatile boolean zzxg;
    final /* synthetic */ zzat zzxe;

    protected zzav(zzat zzat2) {
        this.zzxe = zzat2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzce zzdq() {
        zzk.zzav();
        Intent intent = new Intent("com.google.android.gms.analytics.service.START");
        intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
        Context context = this.zzxe.getContext();
        intent.putExtra("app_package_name", context.getPackageName());
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzav zzav2 = this;
        synchronized (zzav2) {
            this.zzxf = null;
            this.zzxg = true;
            boolean bl = connectionTracker.bindService(context, intent, (ServiceConnection)zzat.zza(this.zzxe), 129);
            this.zzxe.zza("Bind to service requested", bl);
            if (!bl) {
                this.zzxg = false;
                return null;
            }
            try {
                long l = zzby.zzaak.get();
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                this.zzxe.zzt("Wait for service connect was interrupted");
            }
            this.zzxg = false;
            zzce zzce2 = this.zzxf;
            this.zzxf = null;
            if (zzce2 == null) {
                this.zzxe.zzu("Successfully bound to service but never got onServiceConnected callback");
            }
            return zzce2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"AnalyticsServiceConnection.onServiceConnected");
        zzav zzav2 = this;
        synchronized (zzav2) {
            try {
                String string;
                if (iBinder == null) {
                    this.zzxe.zzu("Service connected with null binder");
                    return;
                }
                zzce zzce2 = null;
                try {
                    string = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(string)) {
                        IInterface iInterface;
                        IBinder iBinder2 = iBinder;
                        zzce2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.analytics.internal.IAnalyticsService")) instanceof zzce ? (zzce)iInterface : new zzcf(iBinder2));
                        this.zzxe.zzq("Bound to IAnalyticsService interface");
                    } else {
                        this.zzxe.zze("Got binder with a wrong descriptor", string);
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzxe.zzu("Service connect failed to get IAnalyticsService");
                }
                if (zzce2 == null) {
                    try {
                        ConnectionTracker.getInstance().unbindService(this.zzxe.getContext(), (ServiceConnection)zzat.zza(this.zzxe));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (!this.zzxg) {
                    this.zzxe.zzt("onServiceConnected received after the timeout limit");
                    string = zzce2;
                    this.zzxe.zzcq().zza(new zzaw(this, (zzce)((Object)string)));
                } else {
                    this.zzxf = zzce2;
                }
            }
            finally {
                this.notifyAll();
            }
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"AnalyticsServiceConnection.onServiceDisconnected");
        this.zzxe.zzcq().zza(new zzax(this, componentName));
    }
}

