/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.gtm.zzan;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzar;
import com.google.android.gms.internal.gtm.zzas;
import com.google.android.gms.internal.gtm.zzat;
import com.google.android.gms.internal.gtm.zzay;
import com.google.android.gms.internal.gtm.zzbc;
import com.google.android.gms.internal.gtm.zzbd;
import com.google.android.gms.internal.gtm.zzbe;
import com.google.android.gms.internal.gtm.zzbf;
import com.google.android.gms.internal.gtm.zzbq;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbv;
import com.google.android.gms.internal.gtm.zzbw;
import com.google.android.gms.internal.gtm.zzby;
import com.google.android.gms.internal.gtm.zzcd;
import com.google.android.gms.internal.gtm.zzcj;
import com.google.android.gms.internal.gtm.zzck;
import com.google.android.gms.internal.gtm.zzcp;
import com.google.android.gms.internal.gtm.zzcq;
import com.google.android.gms.internal.gtm.zzcv;
import com.google.android.gms.internal.gtm.zzcz;
import com.google.android.gms.internal.gtm.zzda;
import com.google.android.gms.internal.gtm.zzq;
import com.google.android.gms.internal.gtm.zzr;
import com.google.android.gms.internal.gtm.zzu;
import com.google.android.gms.internal.gtm.zzz;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzbb
extends zzan {
    private boolean started;
    private final zzay zzxp;
    private final zzck zzxq;
    private final zzcj zzxr;
    private final zzat zzxs;
    private long zzxt;
    private final zzbs zzxu;
    private final zzbs zzxv;
    private final zzcv zzxw;
    private long zzxx;
    private boolean zzxy;

    protected zzbb(zzap zzap2, zzar zzar2) {
        super(zzap2);
        Preconditions.checkNotNull((Object)zzar2);
        this.zzxt = Long.MIN_VALUE;
        zzap zzap3 = zzap2;
        this.zzxr = new zzcj(zzap3);
        zzap3 = zzap2;
        this.zzxp = new zzay(zzap3);
        zzap3 = zzap2;
        this.zzxq = new zzck(zzap3);
        zzap3 = zzap2;
        this.zzxs = new zzat(zzap3);
        this.zzxw = new zzcv(this.zzcn());
        this.zzxu = new zzbc(this, zzap2);
        this.zzxv = new zzbd(this, zzap2);
    }

    @Override
    protected final void zzaw() {
        this.zzxp.zzag();
        this.zzxq.zzag();
        this.zzxs.zzag();
    }

    final void start() {
        this.zzdb();
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.started = true;
        this.zzcq().zza(new zzbe(this));
    }

    private final boolean zzx(String string) {
        return Wrappers.packageManager((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzdw() {
        this.zzdb();
        zzbb zzbb2 = this;
        zzk.zzav();
        Context context = zzbb2.zzcm().getContext();
        if (!zzcp.zza(context)) {
            zzbb2.zzt("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzcq.zze(context)) {
            zzbb2.zzu("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zza(context)) {
            zzbb2.zzt("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzcv().zzfv();
        if (!this.zzx("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzu("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzeg();
        }
        if (!this.zzx("android.permission.INTERNET")) {
            this.zzu("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzeg();
        }
        if (zzcq.zze(this.getContext())) {
            this.zzq("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzt("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzxy && !this.zzxp.isEmpty()) {
            this.zzdz();
        }
        this.zzec();
    }

    private final void zzdx() {
        this.zzb(new zzbf(this));
    }

    final void zzcl() {
        zzk.zzav();
        this.zzxx = this.zzcn().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzk.zzav();
        zzbb zzbb2 = this;
        zzk.zzav();
        zzbb2.zzdb();
        if (!zzbq.zzen()) {
            zzbb2.zzt("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzbb2.zzxs.isConnected()) {
            zzbb2.zzq("Service not connected");
            return;
        }
        if (!zzbb2.zzxp.isEmpty()) {
            zzbb2.zzq("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzcd> list;
                try {
                    list = zzbb2.zzxp.zzd(zzbq.zzer());
                    if (list.isEmpty()) {
                        zzbb2.zzec();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzbb2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzbb2.zzee();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzcd zzcd2 = list.get(0);
                    if (!zzbb2.zzxs.zzb(zzcd2)) {
                        zzbb2.zzec();
                        return;
                    }
                    list.remove(zzcd2);
                    try {
                        zzbb2.zzxp.zze(zzcd2.zzfg());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzbb2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzbb2.zzee();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzdy() {
        try {
            this.zzxp.zzdr();
            this.zzec();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzxv.zzh(86400000L);
    }

    protected final void zzb(zzas zzas2) {
        zzk.zzav();
        this.zzb("Sending first hit to property", zzas2.zzdj());
        if (this.zzcv().zzfw().zzj(zzbq.zzex())) {
            return;
        }
        String string = this.zzcv().zzfz();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzr zzr2 = zzcz.zza(this.zzco(), string);
        this.zzb("Found relevant installation campaign", zzr2);
        this.zza(zzas2, zzr2);
    }

    public final void zzg(long l) {
        zzk.zzav();
        this.zzdb();
        if (l < 0L) {
            l = 0L;
        }
        this.zzxt = l;
        this.zzec();
    }

    private final void zzdz() {
        if (this.zzxy) {
            return;
        }
        if (!zzbq.zzen()) {
            return;
        }
        if (this.zzxs.isConnected()) {
            return;
        }
        long l = zzby.zzaan.get();
        if (this.zzxw.zzj(l)) {
            this.zzxw.start();
            this.zzq("Connecting to service");
            if (this.zzxs.connect()) {
                this.zzq("Connected to service");
                this.zzxw.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzas zzas2, boolean bl) {
        long l;
        Preconditions.checkNotNull((Object)zzas2);
        this.zzdb();
        zzk.zzav();
        try {
            this.zzxp.beginTransaction();
            String string = zzas2.zzbt();
            long l2 = zzas2.zzdi();
            zzay zzay2 = this.zzxp;
            Preconditions.checkNotEmpty((String)string);
            zzay2.zzdb();
            zzk.zzav();
            int n = zzay2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzay2.zza("Deleted property records", n);
            }
            l = this.zzxp.zza(zzas2.zzdi(), zzas2.zzbt(), zzas2.zzdj());
            zzas2.zzb(l + 1L);
            zzas zzas3 = zzas2;
            zzay zzay3 = this.zzxp;
            Preconditions.checkNotNull((Object)zzas3);
            zzay3.zzdb();
            zzk.zzav();
            SQLiteDatabase sQLiteDatabase = zzay3.getWritableDatabase();
            Map<String, String> map = zzas3.zzdm();
            Preconditions.checkNotNull(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzas3.zzdi()));
            contentValues.put("cid", zzas3.zzbt());
            contentValues.put("tid", zzas3.zzdj());
            contentValues.put("adid", Integer.valueOf(zzas3.zzdk() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzas3.zzdl()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzay3.zzu("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzay3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzxp.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzxp.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzcd zzcd2) {
        zzcd zzcd3;
        Preconditions.checkNotNull((Object)zzcd2);
        zzk.zzav();
        this.zzdb();
        if (this.zzxy) {
            this.zzr("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzcd2);
        }
        zzcd zzcd4 = zzcd2;
        zzbb zzbb2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzcd4.zzfl())) {
            zzcd3 = zzcd4;
        } else {
            Pair<String, Long> pair = zzbb2.zzcv().zzga().zzgc();
            if (pair == null) {
                zzcd3 = zzcd4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzcd4.zzdm());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzcd zzcd5 = zzcd4;
                zzbb zzbb3 = zzbb2;
                zzcd3 = new zzcd(zzbb3, (Map<String, String>)object2, zzcd5.zzfh(), zzcd5.zzfj(), zzcd5.zzfg(), zzcd5.zzff(), zzcd5.zzfi());
            }
        }
        zzcd2 = zzcd3;
        this.zzdz();
        if (this.zzxs.zzb(zzcd2)) {
            this.zzr("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzxp.zzc(zzcd2);
            this.zzec();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzco().zza(zzcd2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzch() {
        zzk.zzav();
        this.zzdb();
        this.zzq("Delete all hits from local store");
        try {
            zzay zzay2 = this.zzxp;
            zzk.zzav();
            zzay2.zzdb();
            zzay2.getWritableDatabase().delete("hits2", null, null);
            zzay2 = this.zzxp;
            zzk.zzav();
            zzay2.zzdb();
            zzay2.getWritableDatabase().delete("properties", null, null);
            this.zzec();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzdz();
        if (this.zzxs.zzdn()) {
            this.zzq("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzea() {
        boolean bl;
        zzk.zzav();
        this.zzdb();
        this.zzq("Dispatching a batch of local hits");
        boolean bl2 = !this.zzxs.isConnected();
        boolean bl3 = bl = !this.zzxq.zzfr();
        if (bl2 && bl) {
            this.zzq("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzbq.zzer(), zzbq.zzes());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzcd> list;
                block38: {
                    this.zzxp.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzxp.zzd(l);
                        if (!list.isEmpty()) break block38;
                        this.zzq("Store is empty, nothing to dispatch");
                        this.zzee();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzee();
                        try {
                            this.zzxp.setTransactionSuccessful();
                            this.zzxp.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzee();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzfg() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzee();
                    return false;
                }
                if (this.zzxs.isConnected()) {
                    this.zzq("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzxs.zzb((zzcd)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzcd)((Object)list2)).zzfg());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzxp.zze(((zzcd)((Object)list2)).zzfg());
                            arrayList.add(((zzcd)((Object)list2)).zzfg());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzee();
                            try {
                                this.zzxp.setTransactionSuccessful();
                                this.zzxp.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzee();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzxq.zzfr()) {
                    list2 = this.zzxq.zzb(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzxp.zza(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzee();
                        try {
                            this.zzxp.setTransactionSuccessful();
                            this.zzxp.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzee();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzxp.setTransactionSuccessful();
                    this.zzxp.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzee();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzbw zzbw2) {
        long l = this.zzxx;
        zzbw zzbw3 = zzbw2;
        zzbb zzbb2 = this;
        zzk.zzav();
        zzbb2.zzdb();
        long l2 = -1L;
        long l3 = zzbb2.zzcv().zzfx();
        if (l3 != 0L) {
            l2 = Math.abs(zzbb2.zzcn().currentTimeMillis() - l3);
        }
        zzbb2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzbb2.zzdz();
        try {
            zzbb2.zzea();
            zzbb2.zzcv().zzfy();
            zzbb2.zzec();
            if (zzbw3 != null) {
                zzbw3.zza(null);
            }
            if (zzbb2.zzxx != l) {
                zzbb2.zzxr.zzfq();
            }
            return;
        }
        catch (Exception exception) {
            zzbb2.zze("Local dispatch failed", exception);
            zzbb2.zzcv().zzfy();
            zzbb2.zzec();
            if (zzbw3 != null) {
                zzbw3.zza(exception);
            }
            return;
        }
    }

    public final void zzeb() {
        zzk.zzav();
        this.zzdb();
        this.zzr("Sync dispatching local hits");
        long l = this.zzxx;
        this.zzdz();
        try {
            this.zzea();
            this.zzcv().zzfy();
            this.zzec();
            if (this.zzxx != l) {
                this.zzxr.zzfq();
            }
            return;
        }
        catch (Exception exception) {
            this.zze("Sync local dispatch failed", exception);
            this.zzec();
            return;
        }
    }

    private final long zzds() {
        zzk.zzav();
        this.zzdb();
        try {
            return this.zzxp.zzds();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzec() {
        boolean bl;
        zzk.zzav();
        this.zzdb();
        zzbb zzbb2 = this;
        if (!(!zzbb2.zzxy && zzbb2.zzef() > 0L)) {
            this.zzxr.unregister();
            this.zzee();
            return;
        }
        if (this.zzxp.isEmpty()) {
            this.zzxr.unregister();
            this.zzee();
            return;
        }
        if (!zzby.zzaai.get().booleanValue()) {
            this.zzxr.zzfo();
            bl = this.zzxr.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzbb2 = this;
            zzbb2.zzed();
            long l3 = zzbb2.zzef();
            long l4 = zzbb2.zzcv().zzfx();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzbb2.zzcn().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzbq.zzep(), l3)) : Math.min(zzbq.zzep(), l3);
            zzbb2.zza("Dispatch scheduled (ms)", l5);
            if (zzbb2.zzxu.zzez()) {
                l = Math.max(1L, l5 + zzbb2.zzxu.zzey());
                zzbb2.zzxu.zzi(l);
                return;
            }
            zzbb2.zzxu.zzh(l5);
            return;
        }
        this.zzee();
        this.zzed();
    }

    private final void zzed() {
        long l;
        zzbv zzbv2 = this.zzct();
        if (!zzbv2.zzfc()) {
            return;
        }
        if (!zzbv2.zzez() && (l = this.zzds()) != 0L && Math.abs(this.zzcn().currentTimeMillis() - l) <= zzby.zzzm.get()) {
            long l2 = zzbq.zzeq();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzbv2.zzfd();
        }
    }

    private final void zzee() {
        zzbb zzbb2 = this;
        if (zzbb2.zzxu.zzez()) {
            zzbb2.zzq("All hits dispatched or no network/service. Going to power save mode");
        }
        zzbb2.zzxu.cancel();
        zzbv zzbv2 = this.zzct();
        if (zzbv2.zzez()) {
            zzbv2.cancel();
        }
    }

    private final long zzef() {
        if (this.zzxt != Long.MIN_VALUE) {
            return this.zzxt;
        }
        long l = zzby.zzzh.get();
        zzda zzda2 = this.zzcu();
        zzda2.zzdb();
        if (zzda2.zzacv) {
            zzda2 = this.zzcu();
            zzda2.zzdb();
            l = (long)zzda2.zzaax * 1000L;
        }
        return l;
    }

    public final void zzy(String string) {
        Preconditions.checkNotEmpty((String)string);
        zzk.zzav();
        zzr zzr2 = zzcz.zza(this.zzco(), string);
        if (zzr2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzcv().zzfz();
        if (string.equals(string2)) {
            this.zzt("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzcv().zzad(string);
        if (this.zzcv().zzfw().zzj(zzbq.zzex())) {
            this.zzd("Campaign received too late, ignoring", zzr2);
            return;
        }
        this.zzb("Received installation campaign", zzr2);
        for (zzas zzas2 : this.zzxp.zzf(0L)) {
            this.zza(zzas2, zzr2);
        }
    }

    private final void zza(zzas zzas2, zzr zzr2) {
        Preconditions.checkNotNull((Object)zzas2);
        Preconditions.checkNotNull((Object)zzr2);
        zza zza2 = new zza(this.zzcm());
        zza2.zza(zzas2.zzdj());
        zza2.enableAdvertisingIdCollection(zzas2.zzdk());
        zzg zzg2 = ((zzj)zza2).zzac();
        zzz zzz2 = zzg2.zzb(zzz.class);
        zzz2.zzl("data");
        zzz2.zzb(true);
        zzg2.zza(zzr2);
        zzu zzu2 = zzg2.zzb(zzu.class);
        zzq zzq2 = zzg2.zzb(zzq.class);
        for (Map.Entry<String, String> entry : zzas2.zzdm().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzq2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzq2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzq2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzq2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzz2.setUserId(string2);
                continue;
            }
            zzu2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzas2.zzdj(), zzr2);
        zzg2.zza(this.zzcv().zzfv());
        zzg2.zzam();
    }

    private final void zzeg() {
        this.zzdb();
        zzk.zzav();
        this.zzxy = true;
        this.zzxs.disconnect();
        this.zzec();
    }

    static /* synthetic */ void zza(zzbb zzbb2) {
        zzbb2.zzdx();
    }

    static /* synthetic */ void zzb(zzbb zzbb2) {
        zzbb2.zzdy();
    }
}

