/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import com.google.android.gms.internal.gtm.zzpo;
import com.google.android.gms.internal.gtm.zzre;
import com.google.android.gms.internal.gtm.zzrj;
import com.google.android.gms.internal.gtm.zzsv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzqm
extends zzpo<Double>
implements zzrj<Double>,
zzsv,
RandomAccess {
    private static final zzqm zzaxe = new zzqm(new double[0], 0);
    private double[] zzaxf;
    private int size;

    zzqm() {
        this(new double[10], 0);
    }

    private zzqm(double[] dArray, int n) {
        this.zzaxf = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzmz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaxf, n2, this.zzaxf, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzqm)) {
            return super.equals(object);
        }
        zzqm zzqm2 = (zzqm)object;
        if (this.size != zzqm2.size) {
            return false;
        }
        double[] dArray = zzqm2.zzaxf;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzaxf[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzaxf[i]);
            n = n * 31 + zzre.zzz(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzmz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
        if (this.size < this.zzaxf.length) {
            System.arraycopy(this.zzaxf, n, this.zzaxf, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaxf, 0, dArray, 0, n);
            System.arraycopy(this.zzaxf, n, dArray, n + 1, this.size - n);
            this.zzaxf = dArray;
        }
        this.zzaxf[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzmz();
        zzre.checkNotNull(collection);
        if (!(collection instanceof zzqm)) {
            return super.addAll(collection);
        }
        zzqm zzqm2 = (zzqm)collection;
        if (zzqm2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzqm2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzqm2.size;
        if (n > this.zzaxf.length) {
            this.zzaxf = Arrays.copyOf(this.zzaxf, n);
        }
        System.arraycopy(zzqm2.zzaxf, 0, this.zzaxf, this.size, zzqm2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzmz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaxf[i])) continue;
            System.arraycopy(this.zzaxf, i + 1, this.zzaxf, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzah(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
    }

    private final String zzai(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzqm zzqm2 = this;
        zzqm2.zzmz();
        zzqm2.zzah(n);
        double d3 = zzqm2.zzaxf[n];
        zzqm2.zzaxf[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzqm zzqm2 = this;
        zzqm2.zzmz();
        zzqm2.zzah(n);
        double d = zzqm2.zzaxf[n];
        if (n < zzqm2.size - 1) {
            System.arraycopy(zzqm2.zzaxf, n + 1, zzqm2.zzaxf, n, zzqm2.size - n - 1);
        }
        --zzqm2.size;
        ++zzqm2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzrj zzaj(int n) {
        int n2 = n;
        zzqm zzqm2 = this;
        if (n2 < zzqm2.size) {
            throw new IllegalArgumentException();
        }
        return new zzqm(Arrays.copyOf(zzqm2.zzaxf, n2), zzqm2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzqm zzqm2 = this;
        zzqm2.zzah(n);
        return zzqm2.zzaxf[n];
    }

    static {
        zzaxe.zzmi();
    }
}

