/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import com.google.android.gms.internal.gtm.zzpo;
import com.google.android.gms.internal.gtm.zzre;
import com.google.android.gms.internal.gtm.zzrj;
import com.google.android.gms.internal.gtm.zzsv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzrd
extends zzpo<Integer>
implements zzrj<Integer>,
zzsv,
RandomAccess {
    private static final zzrd zzbbf = new zzrd(new int[0], 0);
    private int[] zzbbg;
    private int size;

    public static zzrd zzpo() {
        return zzbbf;
    }

    zzrd() {
        this(new int[10], 0);
    }

    private zzrd(int[] nArray, int n) {
        this.zzbbg = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzmz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbbg, n2, this.zzbbg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzrd)) {
            return super.equals(object);
        }
        zzrd zzrd2 = (zzrd)object;
        if (this.size != zzrd2.size) {
            return false;
        }
        int[] nArray = zzrd2.zzbbg;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbbg[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzbbg[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzah(n);
        return this.zzbbg[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbm(int n) {
        this.zzq(this.size, n);
    }

    private final void zzq(int n, int n2) {
        this.zzmz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
        if (this.size < this.zzbbg.length) {
            System.arraycopy(this.zzbbg, n, this.zzbbg, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbbg, 0, nArray, 0, n);
            System.arraycopy(this.zzbbg, n, nArray, n + 1, this.size - n);
            this.zzbbg = nArray;
        }
        this.zzbbg[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzmz();
        zzre.checkNotNull(collection);
        if (!(collection instanceof zzrd)) {
            return super.addAll(collection);
        }
        zzrd zzrd2 = (zzrd)collection;
        if (zzrd2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzrd2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzrd2.size;
        if (n > this.zzbbg.length) {
            this.zzbbg = Arrays.copyOf(this.zzbbg, n);
        }
        System.arraycopy(zzrd2.zzbbg, 0, this.zzbbg, this.size, zzrd2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzmz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbbg[i])) continue;
            System.arraycopy(this.zzbbg, i + 1, this.zzbbg, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzah(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
    }

    private final String zzai(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzrd zzrd2 = this;
        zzrd2.zzmz();
        zzrd2.zzah(n);
        int n4 = zzrd2.zzbbg[n];
        zzrd2.zzbbg[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzrd zzrd2 = this;
        zzrd2.zzmz();
        zzrd2.zzah(n);
        int n2 = zzrd2.zzbbg[n];
        if (n < zzrd2.size - 1) {
            System.arraycopy(zzrd2.zzbbg, n + 1, zzrd2.zzbbg, n, zzrd2.size - n - 1);
        }
        --zzrd2.size;
        ++zzrd2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzq(n, n2);
    }

    @Override
    public final /* synthetic */ zzrj zzaj(int n) {
        int n2 = n;
        zzrd zzrd2 = this;
        if (n2 < zzrd2.size) {
            throw new IllegalArgumentException();
        }
        return new zzrd(Arrays.copyOf(zzrd2.zzbbg, n2), zzrd2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzbbf.zzmi();
    }
}

