/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.analytics.zzc;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzbq;
import com.google.android.gms.internal.gtm.zzci;
import com.google.android.gms.internal.gtm.zzcz;

@VisibleForTesting
public class CampaignTrackingReceiver
extends BroadcastReceiver {
    private static Boolean zzri;

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzri != null) {
            return zzri;
        }
        boolean bl = zzcz.zza(context, "com.google.android.gms.analytics.CampaignTrackingReceiver", true);
        zzri = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onReceive(Context context, Intent intent) {
        String string;
        zzap zzap2 = zzap.zzc(context);
        zzci zzci2 = zzap2.zzco();
        if (intent == null) {
            zzci2.zzt("CampaignTrackingReceiver received null intent");
            return;
        }
        String string2 = intent.getStringExtra("referrer");
        String string3 = intent.getAction();
        zzci2.zza("CampaignTrackingReceiver received", (Object)string3);
        if (!"com.android.vending.INSTALL_REFERRER".equals(string3) || TextUtils.isEmpty((CharSequence)string2)) {
            zzci2.zzt("CampaignTrackingReceiver received unexpected intent without referrer extra");
            return;
        }
        this.zza(context, string2);
        int n = zzbq.zzeo();
        if (string2.length() <= n) {
            string = string2;
        } else {
            zzci2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n);
            string = string2.substring(0, n);
        }
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        zzap2.zzcs().zza(string, new zzc(this, pendingResult));
    }

    protected void zza(Context context, String string) {
    }
}

