/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzby;
import com.google.android.gms.internal.gtm.zzch;
import com.google.android.gms.internal.gtm.zzcw;
import com.google.android.gms.internal.gtm.zzcy;
import com.google.android.gms.internal.gtm.zzda;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzrp = new ArrayList<Runnable>();
    private boolean zzrq;
    private Set<zza> zzrr = new HashSet<zza>();
    private boolean zzrs;
    private boolean zzrt;
    private volatile boolean zzru;
    private boolean zzrv;

    public final void zzag() {
        GoogleAnalytics googleAnalytics = this;
        zzda zzda2 = googleAnalytics.zzab().zzcu();
        zzda2.zzgh();
        if (zzda2.zzgi()) {
            googleAnalytics.setDryRun(zzda2.zzgj());
        }
        zzda2.zzgh();
        this.zzrq = true;
    }

    public final boolean isInitialized() {
        return this.zzrq;
    }

    @VisibleForTesting
    public GoogleAnalytics(zzap zzap2) {
        super(zzap2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzap.zzc(context).zzde();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzah() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzrp != null) {
                Iterator<Runnable> iterator = zzrp.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzrp = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzrt = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzrt;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzrs) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzrs = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzrs) {
            this.zza(activity);
        }
    }

    @VisibleForTesting
    final void zza(Activity activity) {
        Iterator<zza> iterator = this.zzrr.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzc(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzrs) {
            this.zzb(activity);
        }
    }

    @VisibleForTesting
    final void zzb(Activity activity) {
        Iterator<zza> iterator = this.zzrr.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzab(), string, null);
            tracker.zzag();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzcy zzcy2;
            Tracker tracker = new Tracker(this.zzab(), null, null);
            if (n > 0 && (zzcy2 = (zzcy)new zzcw(this.zzab()).zzq(n)) != null) {
                tracker.zza(zzcy2);
            }
            tracker.zzag();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzrr.add(zza2);
        Context context = this.zzab().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzrr.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzru = bl;
        if (this.zzru) {
            this.zzab().zzcs().zzch();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzru;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzch.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzch.setLogger(logger);
        if (!this.zzrv) {
            String string = zzby.zzzb.get();
            Log.i((String)zzby.zzzb.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzrv = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzab().zzcs().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zzab().zzcs().zzci();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public final void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zza(activity);
        }

        public final void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzb(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzc(Activity var1);

        public void zzd(Activity var1);
    }
}

