/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzae;
import com.google.android.gms.internal.gtm.zzag;
import com.google.android.gms.internal.gtm.zzap;

class zzcj
extends BroadcastReceiver {
    @VisibleForTesting
    private static final String zzabm = zzcj.class.getName();
    private final zzap zzwc;
    private boolean zzabn;
    private boolean zzabo;

    zzcj(zzap zzap2) {
        Preconditions.checkNotNull((Object)zzap2);
        this.zzwc = zzap2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzfp();
        String string = intent.getAction();
        this.zzwc.zzco().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzfr();
            if (this.zzabo != bl) {
                this.zzabo = bl;
                boolean bl2 = bl;
                zzae zzae2 = this.zzwc.zzcs();
                zzae2.zza("Network connectivity status changed", bl2);
                zzae2.zzcq().zza(new zzag(zzae2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzabm)) {
                zzae zzae3 = this.zzwc.zzcs();
                zzae3.zzq("Radio powered up");
                zzae3.zzci();
            }
            return;
        }
        this.zzwc.zzco().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzfo() {
        this.zzfp();
        if (this.zzabn) {
            return;
        }
        Context context = this.zzwc.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzabo = this.zzfr();
        this.zzwc.zzco().zza("Registering connectivity change receiver. Network connected", this.zzabo);
        this.zzabn = true;
    }

    private final void zzfp() {
        this.zzwc.zzco();
        this.zzwc.zzcs();
    }

    public final void unregister() {
        if (!this.zzabn) {
            return;
        }
        this.zzwc.zzco().zzq("Unregistering connectivity change receiver");
        this.zzabn = false;
        this.zzabo = false;
        Context context = this.zzwc.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzwc.zzco().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    @VisibleForTesting
    public final void zzfq() {
        Context context = this.zzwc.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzabm, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.zzabn) {
            this.zzwc.zzco().zzt("Connectivity unknown. Receiver not registered");
        }
        return this.zzabo;
    }

    @VisibleForTesting
    private final boolean zzfr() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzwc.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

