/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import com.google.android.gms.internal.gtm.zzpl;
import com.google.android.gms.internal.gtm.zzpp;
import com.google.android.gms.internal.gtm.zzpr;
import com.google.android.gms.internal.gtm.zzps;
import com.google.android.gms.internal.gtm.zzqk;
import com.google.android.gms.internal.gtm.zzql;
import com.google.android.gms.internal.gtm.zzre;
import com.google.android.gms.internal.gtm.zzrr;
import com.google.android.gms.internal.gtm.zzsk;
import com.google.android.gms.internal.gtm.zzsz;
import com.google.android.gms.internal.gtm.zztx;
import com.google.android.gms.internal.gtm.zztz;
import com.google.android.gms.internal.gtm.zzud;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzqj
extends zzpr {
    private static final Logger logger = Logger.getLogger(zzqj.class.getName());
    private static final boolean zzawt = zztx.zzrm();
    zzql zzawu;

    public static zzqj zzg(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzqj zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zztx.zzrn()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzqj() {
    }

    public abstract void zzd(int var1, int var2) throws IOException;

    public abstract void zze(int var1, int var2) throws IOException;

    public abstract void zzf(int var1, int var2) throws IOException;

    public final void zzg(int n, int n2) throws IOException {
        this.zzf(n, zzqj.zzbi(n2));
    }

    public abstract void zzh(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzqj.zzx(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzh(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzps var2) throws IOException;

    public abstract void zza(int var1, zzsk var2) throws IOException;

    abstract void zza(int var1, zzsk var2, zzsz var3) throws IOException;

    public abstract void zzb(int var1, zzsk var2) throws IOException;

    public abstract void zzb(int var1, zzps var2) throws IOException;

    public abstract void zzax(int var1) throws IOException;

    public abstract void zzay(int var1) throws IOException;

    public final void zzaz(int n) throws IOException {
        this.zzay(zzqj.zzbi(n));
    }

    public abstract void zzba(int var1) throws IOException;

    public abstract void zzp(long var1) throws IOException;

    public final void zzq(long l) throws IOException {
        this.zzp(zzqj.zzx(l));
    }

    public abstract void zzr(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzba(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzr(Double.doubleToRawLongBits(d));
    }

    public final void zzi(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzcz(String var1) throws IOException;

    public abstract void zza(zzps var1) throws IOException;

    public abstract void zzb(zzsk var1) throws IOException;

    abstract void zza(zzsk var1, zzsz var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzi(int n, int n2) {
        return zzqj.zzbb(n) + zzqj.zzbc(n2);
    }

    public static int zzj(int n, int n2) {
        return zzqj.zzbb(n) + zzqj.zzbd(n2);
    }

    public static int zzk(int n, int n2) {
        return zzqj.zzbb(n) + zzqj.zzbd(zzqj.zzbi(n2));
    }

    public static int zzl(int n, int n2) {
        return zzqj.zzbb(n) + 4;
    }

    public static int zzm(int n, int n2) {
        return zzqj.zzbb(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzqj.zzbb(n) + zzqj.zzt(l);
    }

    public static int zze(int n, long l) {
        return zzqj.zzbb(n) + zzqj.zzt(l);
    }

    public static int zzf(int n, long l) {
        return zzqj.zzbb(n) + zzqj.zzt(zzqj.zzx(l));
    }

    public static int zzg(int n, long l) {
        return zzqj.zzbb(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzqj.zzbb(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzqj.zzbb(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzqj.zzbb(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzqj.zzbb(n) + 1;
    }

    public static int zzn(int n, int n2) {
        return zzqj.zzbb(n) + zzqj.zzbc(n2);
    }

    public static int zzb(int n, String string) {
        return zzqj.zzbb(n) + zzqj.zzda(string);
    }

    public static int zzc(int n, zzps zzps2) {
        int n2 = zzps2.size();
        return zzqj.zzbb(n) + (zzqj.zzbd(n2) + n2);
    }

    public static int zza(int n, zzrr zzrr2) {
        int n2 = zzrr2.zzpe();
        return zzqj.zzbb(n) + (zzqj.zzbd(n2) + n2);
    }

    public static int zzc(int n, zzsk zzsk2) {
        return zzqj.zzbb(n) + zzqj.zzc(zzsk2);
    }

    static int zzb(int n, zzsk zzsk2, zzsz zzsz2) {
        return zzqj.zzbb(n) + zzqj.zzb(zzsk2, zzsz2);
    }

    public static int zzd(int n, zzsk zzsk2) {
        return (zzqj.zzbb(1) << 1) + zzqj.zzj(2, n) + zzqj.zzc(3, zzsk2);
    }

    public static int zzd(int n, zzps zzps2) {
        return (zzqj.zzbb(1) << 1) + zzqj.zzj(2, n) + zzqj.zzc(3, zzps2);
    }

    public static int zzb(int n, zzrr zzrr2) {
        return (zzqj.zzbb(1) << 1) + zzqj.zzj(2, n) + zzqj.zza(3, zzrr2);
    }

    public static int zzbb(int n) {
        return zzqj.zzbd(n << 3);
    }

    public static int zzbc(int n) {
        if (n >= 0) {
            return zzqj.zzbd(n);
        }
        return 10;
    }

    public static int zzbd(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzbe(int n) {
        return zzqj.zzbd(zzqj.zzbi(n));
    }

    public static int zzbf(int n) {
        return 4;
    }

    public static int zzbg(int n) {
        return 4;
    }

    public static int zzs(long l) {
        return zzqj.zzt(l);
    }

    public static int zzt(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzu(long l) {
        return zzqj.zzt(zzqj.zzx(l));
    }

    public static int zzv(long l) {
        return 8;
    }

    public static int zzw(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzj(boolean bl) {
        return 1;
    }

    public static int zzbh(int n) {
        return zzqj.zzbc(n);
    }

    public static int zzda(String string) {
        int n;
        try {
            n = zztz.zza(string);
        }
        catch (zzud zzud2) {
            n = string.getBytes(zzre.UTF_8).length;
        }
        int n2 = n;
        return zzqj.zzbd(n2) + n2;
    }

    public static int zza(zzrr zzrr2) {
        int n = zzrr2.zzpe();
        return zzqj.zzbd(n) + n;
    }

    public static int zzb(zzps zzps2) {
        int n = zzps2.size();
        return zzqj.zzbd(n) + n;
    }

    public static int zzh(byte[] byArray) {
        int n = byArray.length;
        return zzqj.zzbd(n) + n;
    }

    public static int zzc(zzsk zzsk2) {
        int n = zzsk2.zzpe();
        return zzqj.zzbd(n) + n;
    }

    static int zzb(zzsk zzsk2, zzsz zzsz2) {
        zzsz zzsz3 = zzsz2;
        zzpl zzpl2 = (zzpl)zzsk2;
        int n = zzpl2.zzmw();
        if (n == -1) {
            n = zzsz3.zzad(zzpl2);
            zzpl2.zzag(n);
        }
        int n2 = n;
        return zzqj.zzbd(n2) + n2;
    }

    private static int zzbi(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzx(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzoi();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzud zzud2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzud2);
        byte[] byArray = string.getBytes(zzre.UTF_8);
        try {
            this.zzay(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzsk zzsk2, zzsz zzsz2) {
        zzsz zzsz3;
        int n2 = zzqj.zzbb(n) << 1;
        zzsz zzsz4 = zzsz3 = zzsz2;
        zzpl zzpl2 = (zzpl)zzsk2;
        int n3 = zzpl2.zzmw();
        if (n3 == -1) {
            n3 = zzsz4.zzad(zzpl2);
            zzpl2.zzag(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzsk zzsk2) {
        return zzsk2.zzpe();
    }

    @Deprecated
    public static int zzbj(int n) {
        return zzqj.zzbd(n);
    }

    /* synthetic */ zzqj(zzqk zzqk2) {
        this();
    }

    static final class zze
    extends zzqj {
        private final ByteBuffer zzawx;
        private final ByteBuffer zzawy;
        private final long zzawz;
        private final long zzaxa;
        private final long zzaxb;
        private final long zzaxc;
        private long zzaxd;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzawx = byteBuffer;
            this.zzawy = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzawz = zztx.zzb(byteBuffer);
            this.zzaxa = this.zzawz + (long)byteBuffer.position();
            this.zzaxb = this.zzawz + (long)byteBuffer.limit();
            this.zzaxc = this.zzaxb - 10L;
            this.zzaxd = this.zzaxa;
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzqj)this).zzay(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzax(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzay(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 5);
            ((zzqj)this).zzba(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzp(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzqj)this).zzd(n, 1);
            ((zzqj)this).zzr(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zzcz(string);
        }

        @Override
        public final void zza(int n, zzps zzps2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zza(zzps2);
        }

        @Override
        public final void zza(int n, zzsk zzsk2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zzb(zzsk2);
        }

        @Override
        final void zza(int n, zzsk zzsk2, zzsz zzsz2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zza(zzsk2, zzsz2);
        }

        @Override
        public final void zzb(int n, zzsk zzsk2) throws IOException {
            ((zzqj)this).zzd(1, 3);
            ((zzqj)this).zzf(2, n);
            ((zzqj)this).zza(3, zzsk2);
            ((zzqj)this).zzd(1, 4);
        }

        @Override
        public final void zzb(int n, zzps zzps2) throws IOException {
            ((zzqj)this).zzd(1, 3);
            ((zzqj)this).zzf(2, n);
            ((zzqj)this).zza(3, zzps2);
            ((zzqj)this).zzd(1, 4);
        }

        @Override
        public final void zzb(zzsk zzsk2) throws IOException {
            ((zzqj)this).zzay(zzsk2.zzpe());
            zzsk2.zzb(this);
        }

        @Override
        final void zza(zzsk zzsk2, zzsz zzsz2) throws IOException {
            zzsz zzsz3 = zzsz2;
            zzpl zzpl2 = (zzpl)zzsk2;
            int n = zzpl2.zzmw();
            if (n == -1) {
                n = zzsz3.zzad(zzpl2);
                zzpl2.zzag(n);
            }
            ((zzqj)this).zzay(n);
            zzsz2.zza(zzsk2, this.zzawu);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzaxd >= this.zzaxb) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaxd, this.zzaxb, 1));
            }
            zztx.zza(this.zzaxd++, by);
        }

        @Override
        public final void zza(zzps zzps2) throws IOException {
            ((zzqj)this).zzay(zzps2.size());
            zzps2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzqj)this).zzay(n2);
            ((zzqj)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzax(int n) throws IOException {
            if (n >= 0) {
                ((zzqj)this).zzay(n);
                return;
            }
            ((zzqj)this).zzp(n);
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (this.zzaxd <= this.zzaxc) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zztx.zza(this.zzaxd++, (byte)n);
                        return;
                    }
                    zztx.zza(this.zzaxd++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzaxd < this.zzaxb) {
                if ((n & 0xFFFFFF80) == 0) {
                    zztx.zza(this.zzaxd++, (byte)n);
                    return;
                }
                zztx.zza(this.zzaxd++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaxd, this.zzaxb, 1));
        }

        @Override
        public final void zzba(int n) throws IOException {
            long l = this.zzaxd;
            zze zze2 = this;
            this.zzawy.putInt((int)(l - zze2.zzawz), n);
            this.zzaxd += 4L;
        }

        @Override
        public final void zzp(long l) throws IOException {
            if (this.zzaxd <= this.zzaxc) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zztx.zza(this.zzaxd++, (byte)l);
                        return;
                    }
                    zztx.zza(this.zzaxd++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzaxd < this.zzaxb) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zztx.zza(this.zzaxd++, (byte)l);
                    return;
                }
                zztx.zza(this.zzaxd++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaxd, this.zzaxb, 1));
        }

        @Override
        public final void zzr(long l) throws IOException {
            long l2 = this.zzaxd;
            zze zze2 = this;
            this.zzawy.putLong((int)(l2 - zze2.zzawz), l);
            this.zzaxd += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzaxb - (long)n2 < this.zzaxd) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaxd, this.zzaxb, n2));
            }
            zztx.zza(byArray, n, this.zzaxd, n2);
            this.zzaxd += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzqj)this).write(byArray, n, n2);
        }

        @Override
        public final void zzcz(String string) throws IOException {
            long l = this.zzaxd;
            try {
                int n = zze.zzbd(string.length() * 3);
                int n2 = zze.zzbd(string.length());
                if (n2 == n) {
                    long l2 = this.zzaxd;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzawz) + n2;
                    this.zzawy.position(n3);
                    zztz.zza(string, this.zzawy);
                    int n4 = this.zzawy.position() - n3;
                    ((zzqj)this).zzay(n4);
                    this.zzaxd += (long)n4;
                    return;
                }
                int n5 = zztz.zza(string);
                ((zzqj)this).zzay(n5);
                this.zzy(this.zzaxd);
                zztz.zza(string, this.zzawy);
                this.zzaxd += (long)n5;
                return;
            }
            catch (zzud zzud2) {
                this.zzaxd = l;
                this.zzy(this.zzaxd);
                this.zza(string, zzud2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzaxd;
            zze zze2 = this;
            this.zzawx.position((int)(l - zze2.zzawz));
        }

        @Override
        public final int zzoi() {
            return (int)(this.zzaxb - this.zzaxd);
        }

        private final void zzy(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzawy.position((int)(l2 - zze2.zzawz));
        }
    }

    static final class zzd
    extends zzqj {
        private final ByteBuffer zzawx;
        private final ByteBuffer zzawy;
        private final int zzaww;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzawx = byteBuffer;
            this.zzawy = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzaww = byteBuffer.position();
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzqj)this).zzay(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzax(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzay(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 5);
            ((zzqj)this).zzba(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzp(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzqj)this).zzd(n, 1);
            ((zzqj)this).zzr(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zzcz(string);
        }

        @Override
        public final void zza(int n, zzps zzps2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zza(zzps2);
        }

        @Override
        public final void zza(int n, zzsk zzsk2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zzb(zzsk2);
        }

        @Override
        final void zza(int n, zzsk zzsk2, zzsz zzsz2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zza(zzsk2, zzsz2);
        }

        @Override
        public final void zzb(int n, zzsk zzsk2) throws IOException {
            ((zzqj)this).zzd(1, 3);
            ((zzqj)this).zzf(2, n);
            ((zzqj)this).zza(3, zzsk2);
            ((zzqj)this).zzd(1, 4);
        }

        @Override
        public final void zzb(int n, zzps zzps2) throws IOException {
            ((zzqj)this).zzd(1, 3);
            ((zzqj)this).zzf(2, n);
            ((zzqj)this).zza(3, zzps2);
            ((zzqj)this).zzd(1, 4);
        }

        @Override
        public final void zzb(zzsk zzsk2) throws IOException {
            ((zzqj)this).zzay(zzsk2.zzpe());
            zzsk2.zzb(this);
        }

        @Override
        final void zza(zzsk zzsk2, zzsz zzsz2) throws IOException {
            zzsz zzsz3 = zzsz2;
            zzpl zzpl2 = (zzpl)zzsk2;
            int n = zzpl2.zzmw();
            if (n == -1) {
                n = zzsz3.zzad(zzpl2);
                zzpl2.zzag(n);
            }
            ((zzqj)this).zzay(n);
            zzsz2.zza(zzsk2, this.zzawu);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzawy.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzps zzps2) throws IOException {
            ((zzqj)this).zzay(zzps2.size());
            zzps2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzqj)this).zzay(n2);
            ((zzqj)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzax(int n) throws IOException {
            if (n >= 0) {
                ((zzqj)this).zzay(n);
                return;
            }
            ((zzqj)this).zzp(n);
        }

        @Override
        public final void zzay(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzawy.put((byte)n);
                        return;
                    }
                    this.zzawy.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzba(int n) throws IOException {
            try {
                this.zzawy.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzp(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzawy.put((byte)l);
                        return;
                    }
                    this.zzawy.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzr(long l) throws IOException {
            try {
                this.zzawy.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzawy.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzqj)this).write(byArray, n, n2);
        }

        @Override
        public final void zzcz(String string) throws IOException {
            int n = this.zzawy.position();
            try {
                int n2 = zzd.zzbd(string.length() * 3);
                int n3 = zzd.zzbd(string.length());
                if (n3 == n2) {
                    int n4 = this.zzawy.position() + n3;
                    this.zzawy.position(n4);
                    this.zzdb(string);
                    int n5 = this.zzawy.position();
                    this.zzawy.position(n);
                    ((zzqj)this).zzay(n5 - n4);
                    this.zzawy.position(n5);
                    return;
                }
                int n6 = zztz.zza(string);
                ((zzqj)this).zzay(n6);
                this.zzdb(string);
                return;
            }
            catch (zzud zzud2) {
                this.zzawy.position(n);
                this.zza(string, zzud2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzawx.position(this.zzawy.position());
        }

        @Override
        public final int zzoi() {
            return this.zzawy.remaining();
        }

        private final void zzdb(String string) throws IOException {
            try {
                zztz.zza(string, this.zzawy);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzawv;
        private int zzaww;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzawv = byteBuffer;
            this.zzaww = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzawv.position(this.zzaww + this.zzok());
        }
    }

    static class zza
    extends zzqj {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzqj)this).zzay(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzax(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzay(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzqj)this).zzd(n, 5);
            ((zzqj)this).zzba(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzp(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzqj)this).zzd(n, 1);
            ((zzqj)this).zzr(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzqj)this).zzd(n, 0);
            ((zzqj)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zzcz(string);
        }

        @Override
        public final void zza(int n, zzps zzps2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zza(zzps2);
        }

        @Override
        public final void zza(zzps zzps2) throws IOException {
            ((zzqj)this).zzay(zzps2.size());
            zzps2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzqj)this).zzay(n2);
            ((zzqj)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzsk zzsk2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            ((zzqj)this).zzb(zzsk2);
        }

        @Override
        final void zza(int n, zzsk zzsk2, zzsz zzsz2) throws IOException {
            ((zzqj)this).zzd(n, 2);
            zzsz zzsz3 = zzsz2;
            zzpl zzpl2 = (zzpl)zzsk2;
            int n2 = zzpl2.zzmw();
            if (n2 == -1) {
                n2 = zzsz3.zzad(zzpl2);
                zzpl2.zzag(n2);
            }
            ((zzqj)this).zzay(n2);
            zzsz2.zza(zzsk2, this.zzawu);
        }

        @Override
        public final void zzb(int n, zzsk zzsk2) throws IOException {
            ((zzqj)this).zzd(1, 3);
            ((zzqj)this).zzf(2, n);
            ((zzqj)this).zza(3, zzsk2);
            ((zzqj)this).zzd(1, 4);
        }

        @Override
        public final void zzb(int n, zzps zzps2) throws IOException {
            ((zzqj)this).zzd(1, 3);
            ((zzqj)this).zzf(2, n);
            ((zzqj)this).zza(3, zzps2);
            ((zzqj)this).zzd(1, 4);
        }

        @Override
        public final void zzb(zzsk zzsk2) throws IOException {
            ((zzqj)this).zzay(zzsk2.zzpe());
            zzsk2.zzb(this);
        }

        @Override
        final void zza(zzsk zzsk2, zzsz zzsz2) throws IOException {
            zzsz zzsz3 = zzsz2;
            zzpl zzpl2 = (zzpl)zzsk2;
            int n = zzpl2.zzmw();
            if (n == -1) {
                n = zzsz3.zzad(zzpl2);
                zzpl2.zzag(n);
            }
            ((zzqj)this).zzay(n);
            zzsz2.zza(zzsk2, this.zzawu);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzax(int n) throws IOException {
            if (n >= 0) {
                ((zzqj)this).zzay(n);
                return;
            }
            ((zzqj)this).zzp(n);
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (zzawt && !zzpp.zzna() && ((zzqj)this).zzoi() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    zztx.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zztx.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zztx.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zztx.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zztx.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zztx.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zztx.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zztx.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                zztx.zza(this.buffer, (long)this.position++, (byte)(n >>>= 7));
                return;
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzba(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzp(long l) throws IOException {
            if (zzawt && ((zzqj)this).zzoi() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zztx.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zztx.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzr(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzqj)this).write(byArray, n, n2);
        }

        @Override
        public final void zzcz(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzbd(string.length() * 3);
                int n3 = zza.zzbd(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zztz.zza(string, this.buffer, this.position, ((zzqj)this).zzoi());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzqj)this).zzay(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zztz.zza(string);
                ((zzqj)this).zzay(n6);
                this.position = zztz.zza(string, this.buffer, this.position, ((zzqj)this).zzoi());
                return;
            }
            catch (zzud zzud2) {
                this.position = n;
                this.zza(string, zzud2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzoi() {
            return this.limit - this.position;
        }

        public final int zzok() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

