/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import com.google.android.gms.internal.gtm.zzpo;
import com.google.android.gms.internal.gtm.zzre;
import com.google.android.gms.internal.gtm.zzrj;
import com.google.android.gms.internal.gtm.zzsv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzry
extends zzpo<Long>
implements zzrj<Long>,
zzsv,
RandomAccess {
    private static final zzry zzbck = new zzry(new long[0], 0);
    private long[] zzbcl;
    private int size;

    zzry() {
        this(new long[10], 0);
    }

    private zzry(long[] lArray, int n) {
        this.zzbcl = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzmz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbcl, n2, this.zzbcl, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzry)) {
            return super.equals(object);
        }
        zzry zzry2 = (zzry)object;
        if (this.size != zzry2.size) {
            return false;
        }
        long[] lArray = zzry2.zzbcl;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbcl[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzre.zzz(this.zzbcl[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzah(n);
        return this.zzbcl[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzaa(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzmz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
        if (this.size < this.zzbcl.length) {
            System.arraycopy(this.zzbcl, n, this.zzbcl, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbcl, 0, lArray, 0, n);
            System.arraycopy(this.zzbcl, n, lArray, n + 1, this.size - n);
            this.zzbcl = lArray;
        }
        this.zzbcl[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzmz();
        zzre.checkNotNull(collection);
        if (!(collection instanceof zzry)) {
            return super.addAll(collection);
        }
        zzry zzry2 = (zzry)collection;
        if (zzry2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzry2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzry2.size;
        if (n > this.zzbcl.length) {
            this.zzbcl = Arrays.copyOf(this.zzbcl, n);
        }
        System.arraycopy(zzry2.zzbcl, 0, this.zzbcl, this.size, zzry2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzmz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbcl[i])) continue;
            System.arraycopy(this.zzbcl, i + 1, this.zzbcl, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzah(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
    }

    private final String zzai(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzry zzry2 = this;
        zzry2.zzmz();
        zzry2.zzah(n);
        long l3 = zzry2.zzbcl[n];
        zzry2.zzbcl[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzry zzry2 = this;
        zzry2.zzmz();
        zzry2.zzah(n);
        long l = zzry2.zzbcl[n];
        if (n < zzry2.size - 1) {
            System.arraycopy(zzry2.zzbcl, n + 1, zzry2.zzbcl, n, zzry2.size - n - 1);
        }
        --zzry2.size;
        ++zzry2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzrj zzaj(int n) {
        int n2 = n;
        zzry zzry2 = this;
        if (n2 < zzry2.size) {
            throw new IllegalArgumentException();
        }
        return new zzry(Arrays.copyOf(zzry2.zzbcl, n2), zzry2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzbck.zzmi();
    }
}

