/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.zzr;
import com.google.android.gms.analytics.zzu;
import com.google.android.gms.analytics.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzbi;
import com.google.android.gms.internal.gtm.zzbq;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbv;
import com.google.android.gms.internal.gtm.zzcf;
import com.google.android.gms.internal.gtm.zzcx;
import com.google.android.gms.internal.gtm.zzez;
import com.google.android.gms.internal.gtm.zzfb;
import com.google.android.gms.internal.gtm.zzfr;
import com.google.android.gms.internal.gtm.zzfs;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

@VisibleForTesting
public class Tracker
extends zzbs {
    private boolean zza;
    private final Map<String, String> zzb;
    private final Map<String, String> zzc;
    private final zzez zzd;
    private final zzv zze;
    private ExceptionReporter zzf;
    private zzfr zzg;

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public String get(@RecentlyNonNull String key) {
        void var1_1;
        this.zzW();
        if (TextUtils.isEmpty((CharSequence)var1_1)) {
            return null;
        }
        if (this.zzb.containsKey(var1_1)) {
            return this.zzb.get(var1_1);
        }
        if (var1_1.equals("&ul")) {
            return zzfs.zzd(Locale.getDefault());
        }
        if (var1_1.equals("&cid")) {
            return this.zzv().zzb();
        }
        if (var1_1.equals("&sr")) {
            return this.zzx().zzb();
        }
        if (var1_1.equals("&aid")) {
            return this.zzu().zza().zzd();
        }
        if (var1_1.equals("&an")) {
            return this.zzu().zza().zzf();
        }
        if (var1_1.equals("&av")) {
            return this.zzu().zza().zzg();
        }
        if (var1_1.equals("&aiid")) {
            return this.zzu().zza().zze();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void enableAdvertisingIdCollection(boolean enabled) {
        void var1_1;
        this.zza = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void enableAutoActivityTracking(boolean enabled) {
        void var1_1;
        this.zze.zzc((boolean)var1_1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableExceptionReporting(boolean enable) {
        synchronized (this) {
            void var1_1;
            ExceptionReporter exceptionReporter = this.zzf;
            boolean bl = exceptionReporter != null;
            if (bl == var1_1) {
                return;
            }
            if (var1_1 != false) {
                Context context = this.zzo();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzf = exceptionReporter = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzf);
                this.zzO("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(exceptionReporter.zza());
                this.zzO("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(@RecentlyNonNull Map<String, String> params) {
        String string;
        Object object222222;
        String string2;
        long l = this.zzC().currentTimeMillis();
        if (this.zzp().getAppOptOut()) {
            this.zzF("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzp().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzZ(this.zzb, hashMap);
        Tracker.zzZ((Map<String, String>)((Object)string2), hashMap);
        string2 = this.zzb.get("useSecure");
        boolean bl2 = string2 != null ? (!string2.equalsIgnoreCase("true") ? (!string2.equalsIgnoreCase("yes") ? (string2.equalsIgnoreCase("1") ? true : (!string2.equalsIgnoreCase("false") ? (!string2.equalsIgnoreCase("no") ? !string2.equalsIgnoreCase("0") : false) : false)) : true) : true) : true;
        Map<String, String> map = this.zzc;
        Preconditions.checkNotNull(hashMap);
        for (Object object222222 : map.entrySet()) {
            string = Tracker.zzn((Map.Entry<String, String>)object222222);
            if (string == null || hashMap.containsKey(string)) continue;
            hashMap.put(string, (String)object222222.getValue());
        }
        this.zzc.clear();
        object222222 = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)object222222)) {
            this.zzz().zzc(hashMap, "Missing hit type parameter");
            return;
        }
        string = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzz().zzc(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zza;
        synchronized (this) {
            int n = "screenview".equalsIgnoreCase((String)object222222);
            if (n != 0 || (n = "pageview".equalsIgnoreCase((String)object222222)) != 0 || (n = "appview".equalsIgnoreCase((String)object222222)) != 0 || (n = (int)(TextUtils.isEmpty((CharSequence)object222222) ? 1 : 0)) != 0) {
                String string3 = this.zzb.get("&a");
                Preconditions.checkNotNull((Object)string3);
                n = Integer.parseInt(string3);
                if (++n >= Integer.MAX_VALUE) {
                    n = 1;
                }
                this.zzb.put("&a", Integer.toString(n));
            }
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl44 : MonitorExitStatement: MONITOREXIT : this
            zzr zzr2 = this.zzq();
            zzu zzu2 = new zzu(this, hashMap, bl3, (String)object222222, l, bl, bl2, string);
            zzr2.zzi(zzu2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void set(@RecentlyNonNull String key, @RecentlyNonNull String value) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)var1_1)) {
            return;
        }
        this.zzb.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setAnonymizeIp(boolean anonymize) {
        void var1_1;
        this.set("&aip", zzfs.zzc((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setAppId(@RecentlyNonNull String appId) {
        void var1_1;
        this.set("&aid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppInstallerId(@RecentlyNonNull String appInstallerId) {
        void var1_1;
        this.set("&aiid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppName(@RecentlyNonNull String appName) {
        void var1_1;
        this.set("&an", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppVersion(@RecentlyNonNull String appVersion) {
        void var1_1;
        this.set("&av", (String)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCampaignParamsOnNextHit(@RecentlyNonNull Uri uri) {
        String string;
        if (uri == null || string.isOpaque()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(string = string.getQueryParameter("referrer")))) {
            return;
        }
        string = String.valueOf(string);
        String string2 = "http://hostname/?";
        string = string.length() != 0 ? string2.concat(string) : new String(string2);
        string2 = (string = Uri.parse((String)string)).getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzc.put("&ci", string2);
        }
        if ((string2 = string.getQueryParameter("anid")) != null) {
            this.zzc.put("&anid", string2);
        }
        if ((string2 = string.getQueryParameter("utm_campaign")) != null) {
            this.zzc.put("&cn", string2);
        }
        if ((string2 = string.getQueryParameter("utm_content")) != null) {
            this.zzc.put("&cc", string2);
        }
        if ((string2 = string.getQueryParameter("utm_medium")) != null) {
            this.zzc.put("&cm", string2);
        }
        if ((string2 = string.getQueryParameter("utm_source")) != null) {
            this.zzc.put("&cs", string2);
        }
        if ((string2 = string.getQueryParameter("utm_term")) != null) {
            this.zzc.put("&ck", string2);
        }
        if ((string2 = string.getQueryParameter("dclid")) != null) {
            this.zzc.put("&dclid", string2);
        }
        if ((string2 = string.getQueryParameter("gclid")) != null) {
            this.zzc.put("&gclid", string2);
        }
        if ((string = string.getQueryParameter("aclid")) != null) {
            this.zzc.put("&aclid", string);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setClientId(@RecentlyNonNull String clientId) {
        void var1_1;
        this.set("&cid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoding(@RecentlyNonNull String encoding) {
        void var1_1;
        this.set("&de", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setHostname(@RecentlyNonNull String hostname) {
        void var1_1;
        this.set("&dh", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLanguage(@RecentlyNonNull String language) {
        void var1_1;
        this.set("&ul", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLocation(@RecentlyNonNull String location) {
        void var1_1;
        this.set("&dl", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPage(@RecentlyNonNull String page) {
        void var1_1;
        this.set("&dp", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setReferrer(@RecentlyNonNull String referrer) {
        void var1_1;
        this.set("&dr", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleRate(double sampleRate) {
        void var1_1;
        this.set("&sf", Double.toString((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenColors(@RecentlyNonNull String screenColors) {
        void var1_1;
        this.set("&sd", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenName(@RecentlyNonNull String screenName) {
        void var1_1;
        this.set("&cd", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenResolution(int width, int height) {
        void var1_1;
        void var2_2;
        if (width < 0 && var2_2 < 0) {
            this.zzR("Invalid width or height. The values should be non-negative.");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(23);
        stringBuilder.append((int)var1_1);
        stringBuilder.append("x");
        stringBuilder.append((int)var2_2);
        this.set("&sr", stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionTimeout(long sessionTimeout) {
        void var1_1;
        this.zze.zze((long)(var1_1 * 1000L));
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(@RecentlyNonNull String title) {
        void var1_1;
        this.set("&dt", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUseSecure(boolean useSecure) {
        void var1_1;
        this.set("useSecure", zzfs.zzc((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setViewportSize(@RecentlyNonNull String viewportSize) {
        void var1_1;
        this.set("&vp", (String)var1_1);
    }

    static /* bridge */ /* synthetic */ zzv zza(Tracker tracker) {
        return tracker.zze;
    }

    static /* synthetic */ zzbi zzb(Tracker tracker) {
        return tracker.zzr();
    }

    static /* synthetic */ zzbq zzc(Tracker tracker) {
        return tracker.zzs();
    }

    static /* synthetic */ zzbq zze(Tracker tracker) {
        return tracker.zzs();
    }

    static /* synthetic */ zzcf zzf(Tracker tracker) {
        return tracker.zzu();
    }

    static /* synthetic */ zzcx zzg(Tracker tracker) {
        return tracker.zzx();
    }

    static /* synthetic */ zzcx zzh(Tracker tracker) {
        return tracker.zzx();
    }

    static /* bridge */ /* synthetic */ zzez zzi(Tracker tracker) {
        return tracker.zzd;
    }

    static /* synthetic */ zzfb zzj(Tracker tracker) {
        return tracker.zzz();
    }

    static /* synthetic */ zzfb zzk(Tracker tracker) {
        return tracker.zzz();
    }

    static /* bridge */ /* synthetic */ zzfr zzl(Tracker tracker) {
        return tracker.zzg;
    }

    private static String zzn(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!string.startsWith("&") || string.length() < 2) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    Tracker(zzbv zzbv2, String object, zzez serializable) {
        super(zzbv2);
        serializable = new HashMap();
        this.zzb = serializable;
        serializable = new HashMap();
        this.zzc = serializable;
        if (object != null) {
            this.zzb.put("&tid", (String)object);
        }
        this.zzb.put("useSecure", "1");
        object = this.zzb;
        super();
        object.put("&a", Integer.toString(((Random)serializable).nextInt(Integer.MAX_VALUE) + 1));
        this.zzd = object = new zzez(60, 2000L, "tracking", this.zzC());
        this.zze = object = new zzv(this, zzbv2);
    }

    private static void zzZ(Map<String, String> object, Map<String, String> map) {
        Preconditions.checkNotNull(map);
        if (object == null) {
            return;
        }
        for (Map.Entry<String, String> entry : object.entrySet()) {
            String string = Tracker.zzn(entry);
            if (string == null) continue;
            map.put(string, entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzm(zzfr zzfr2) {
        boolean bl;
        double d;
        this.zzO("Loading Tracker config values");
        this.zzg = zzfr2;
        String string = zzfr2.zza;
        if (string != null) {
            this.set("&tid", string);
            this.zzP("trackingId loaded", string);
        }
        if ((d = zzfr2.zzb) >= 0.0) {
            string = Double.toString(d);
            this.set("&sf", string);
            this.zzP("Sample frequency loaded", string);
        }
        if ((bl = zzfr2.zzc) >= false) {
            this.setSessionTimeout((long)bl);
            this.zzP("Session timeout loaded", bl ? 1 : 0);
        }
        if (!(bl = zzfr2.zzd)) {
            bl = true == bl;
            this.enableAutoActivityTracking(bl);
            this.zzP("Auto activity tracking loaded", bl);
        }
        if (!(bl = zzfr2.zze)) {
            if (bl) {
                this.set("&aip", "1");
            }
            bl = true == bl;
            this.zzP("Anonymize ip loaded", bl);
        }
        boolean bl2 = zzfr2.zzf == 1;
        this.enableExceptionReporting(bl2);
    }

    @Override
    protected final void zzd() {
        this.zze.zzX();
        String string = this.zzB().zza();
        if (string != null) {
            this.set("&an", string);
        }
        if ((string = this.zzB().zzb()) != null) {
            this.set("&av", string);
            return;
        }
    }
}

