/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbv;
import com.google.android.gms.internal.gtm.zzct;
import com.google.android.gms.internal.gtm.zzeu;
import com.google.android.gms.internal.gtm.zzfu;
import com.google.android.gms.internal.gtm.zzfv;

public final class zzcy
extends zzbs {
    private boolean zza;
    private boolean zzb;
    private final AlarmManager zzc = (AlarmManager)this.zzo().getSystemService("alarm");
    private Integer zzd;

    /*
     * Enabled aggressive block sorting
     */
    private final int zzf() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzo().getPackageName());
            String string2 = "analytics";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            this.zzd = string.hashCode();
        }
        return this.zzd;
    }

    private final PendingIntent zzg() {
        zzcy zzcy2 = zzcy2.zzo();
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        ComponentName componentName = new ComponentName((Context)zzcy2, "com.google.android.gms.analytics.AnalyticsReceiver");
        return zzfu.zza((Context)zzcy2, 0, intent.setComponent(componentName), zzfu.zza);
    }

    protected zzcy(zzbv zzbv2) {
        super(zzbv2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        this.zzb = false;
        try {
            this.zzc.cancel(this.zzg());
        }
        catch (NullPointerException nullPointerException) {}
        if (Build.VERSION.SDK_INT >= 24) {
            Context context = this.zzo();
            Object object = context.getSystemService("jobscheduler");
            JobScheduler jobScheduler = (JobScheduler)object;
            int n = this.zzf();
            this.zzP("Cancelling job. JobID", n);
            jobScheduler.cancel(n);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final void zzd() {
        try {
            this.zza();
            this.zzw();
            long l = zzct.zzd();
            if (l <= 0L) return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
        Context context = this.zzo();
        PackageManager packageManager = context.getPackageManager();
        ComponentName componentName = new ComponentName(context, "com.google.android.gms.analytics.AnalyticsReceiver");
        context = packageManager.getReceiverInfo(componentName, 0);
        if (context == null) return;
        boolean bl = context.enabled;
        if (!bl) return;
        this.zzO("Receiver registered for local dispatch.");
        this.zza = true;
    }

    public final void zzb() {
        this.zzW();
        Preconditions.checkState((boolean)this.zza, (Object)"Receiver not registered");
        this.zzw();
        long l = zzct.zzd();
        if (l > 0L) {
            this.zza();
            long l2 = this.zzC().elapsedRealtime() + l;
            this.zzb = true;
            zzeu.zzR.zzb().booleanValue();
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzO("Scheduling upload with JobScheduler");
                Context context = this.zzo();
                ComponentName componentName = new ComponentName(context, "com.google.android.gms.analytics.AnalyticsJobService");
                int n = this.zzf();
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
                componentName = builder.setMinimumLatency(l);
                componentName = componentName.setOverrideDeadline(l + l);
                componentName = componentName.setExtras(persistableBundle);
                componentName = componentName.build();
                this.zzP("Scheduling job. JobID", n);
                zzfv.zza(context, (JobInfo)componentName, "com.google.android.gms", "DispatchAlarm");
                return;
            }
            this.zzO("Scheduling upload with AlarmManager");
            this.zzc.setInexactRepeating(2, l2, l, this.zzg());
            return;
        }
    }

    public final boolean zzc() {
        return this.zza;
    }

    public final boolean zze() {
        return this.zzb;
    }
}

