/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbv;
import com.google.android.gms.internal.gtm.zzfo;
import com.google.android.gms.internal.gtm.zzfs;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

@VisibleForTesting
public final class zzbi
extends zzbs {
    public static boolean zza;
    private AdvertisingIdClient.Info zzb;
    private final zzfo zzc;
    private String zzd;
    private boolean zze = false;
    private final Object zzf;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized AdvertisingIdClient.Info zzc() {
        AdvertisingIdClient.Info info;
        block34: {
            block40: {
                block33: {
                    block31: {
                        if (!this.zzc.zzc(1000L)) return this.zzb;
                        this.zzc.zzb();
                        try {
                            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzo());
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzR("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
                            info = null;
                        }
                        catch (Exception exception) {
                            if (zza) break block31;
                            zza = true;
                            this.zzS("Error getting advertiser id", exception);
                            info = null;
                        }
                        break block33;
                    }
                    info = null;
                }
                Object object = this.zzb;
                Object object2 = info == null ? null : info.getId();
                if (TextUtils.isEmpty((CharSequence)object2)) break block34;
                String string = this.zzv().zzb();
                Object object3 = this.zzf;
                synchronized (object3) {
                    boolean bl;
                    block37: {
                        String string2;
                        boolean bl2;
                        int n;
                        block41: {
                            block39: {
                                int n2;
                                block35: {
                                    block32: {
                                        String string3;
                                        Object object4;
                                        block36: {
                                            int n3 = this.zze;
                                            if (n3 == 0) {
                                                object = this.zzo().openFileInput("gaClientIdData");
                                                object4 = new byte[128];
                                                n2 = ((FileInputStream)object).read((byte[])object4, 0, 128);
                                                int n4 = ((FileInputStream)object).available();
                                                if (n4 > 0) {
                                                    this.zzR("Hash file seems corrupted, deleting it.");
                                                    ((FileInputStream)object).close();
                                                    this.zzo().deleteFile("gaClientIdData");
                                                    object = null;
                                                    break block32;
                                                }
                                                if (n2 <= 0) {
                                                    this.zzO("Hash file is empty.");
                                                    ((FileInputStream)object).close();
                                                    object = null;
                                                    break block32;
                                                }
                                                string3 = new String((byte[])object4, 0, n2);
                                                ((FileInputStream)object).close();
                                                object = string3;
                                                break block32;
                                            }
                                            n3 = TextUtils.isEmpty((CharSequence)this.zzd);
                                            if (n3 == 0) break block35;
                                            if ((object = object == null ? null : object.getId()) != null) break block36;
                                            object2 = String.valueOf(object2);
                                            object = String.valueOf(string);
                                            n3 = ((String)object).length();
                                            object2 = n3 != 0 ? ((String)object2).concat((String)object) : (object = new String((String)object2));
                                            bl = this.zzf((String)object2);
                                            break block37;
                                        }
                                        String string4 = String.valueOf(string);
                                        n2 = string4.length();
                                        if (n2 != 0) {
                                            object = ((String)object).concat(string4);
                                        } else {
                                            string4 = new String((String)object);
                                            object = string4;
                                        }
                                        this.zzd = zzbi.zze((String)object);
                                        break block35;
                                        catch (FileNotFoundException fileNotFoundException) {
                                            object = null;
                                        }
                                        catch (IOException iOException) {
                                            block38: {
                                                object4 = null;
                                                break block38;
                                                catch (FileNotFoundException fileNotFoundException) {
                                                    object = string3;
                                                    break block32;
                                                }
                                                catch (IOException iOException2) {
                                                    object4 = string3;
                                                }
                                            }
                                            this.zzS("Error reading Hash file, deleting it", object);
                                            this.zzo().deleteFile("gaClientIdData");
                                            object = object4;
                                        }
                                    }
                                    this.zzd = object;
                                    this.zze = true;
                                }
                                object = String.valueOf(object2);
                                String string5 = String.valueOf(string);
                                n2 = string5.length();
                                if (n2 != 0) {
                                    object = ((String)object).concat(string5);
                                } else {
                                    string5 = new String((String)object);
                                    object = string5;
                                }
                                if ((n = TextUtils.isEmpty((CharSequence)(object = zzbi.zze((String)object)))) == 0) break block39;
                                break block40;
                            }
                            bl2 = ((String)object).equals(this.zzd);
                            if (!bl2) break block41;
                            break block34;
                        }
                        bl2 = TextUtils.isEmpty((CharSequence)this.zzd);
                        if (!bl2) {
                            this.zzO("Resetting the client id because Advertising Id changed.");
                            string2 = this.zzv().zze();
                            this.zzP("New client Id", string2);
                        } else {
                            string2 = string;
                        }
                        object2 = String.valueOf(object2);
                        n = (string2 = String.valueOf(string2)).length();
                        if (n != 0) {
                            object2 = ((String)object2).concat(string2);
                        } else {
                            string2 = new String((String)object2);
                            object2 = string2;
                        }
                        bl = this.zzf((String)object2);
                    }
                    if (bl) break block34;
                }
            }
            this.zzJ("Failed to reset client id on adid change. Not using adid");
            this.zzb = info = new AdvertisingIdClient.Info("", false);
            return this.zzb;
        }
        this.zzb = info;
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String zza() {
        ((zzbs)object).zzW();
        Object object = ((zzbi)object).zzc();
        object = object != null ? object.getId() : null;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        return object;
    }

    private static String zze(String string) {
        MessageDigest messageDigest = zzfs.zze("MD5");
        if (messageDigest == null) {
            return null;
        }
        Locale locale = Locale.US;
        Object[] objectArray = new Object[1];
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest(string.getBytes()));
        objectArray[0] = bigInteger;
        return String.format(locale, "%032X", objectArray);
    }

    zzbi(zzbv zzbv2) {
        super(zzbv2);
        Object object;
        this.zzf = object = new Object();
        this.zzc = object = new zzfo(zzbv2.zzr());
    }

    @Override
    protected final void zzd() {
    }

    public final boolean zzb() {
        zzbi2.zzW();
        zzbi zzbi2 = zzbi2.zzc();
        if (zzbi2 != null) {
            return !zzbi2.isLimitAdTrackingEnabled();
        }
        return false;
    }

    private final boolean zzf(String string) {
        try {
            string = zzbi.zze(string);
            this.zzO("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.zzo().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
            this.zzd = string;
            return true;
        }
        catch (IOException iOException) {
            this.zzK("Error creating hash file", iOException);
            return false;
        }
    }
}

