/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzTT;
    private final Tracker zzTU;
    private final Context mContext;
    private ExceptionParser zzTV;
    private GoogleAnalytics zzTW;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzTT = uncaughtExceptionHandler;
        this.zzTU = tracker;
        this.zzTV = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzae.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzTV;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzTV = exceptionParser;
    }

    GoogleAnalytics zzkq() {
        if (this.zzTW == null) {
            this.zzTW = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzTW;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzTV != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzTV.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzae.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzTU.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzkq();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzkv();
        if (this.zzTT != null) {
            zzae.v("Passing exception to the original handler");
            this.zzTT.uncaughtException(thread, throwable);
        }
    }

    Thread.UncaughtExceptionHandler zzkr() {
        return this.zzTT;
    }
}

