/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzap;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzTX = new ArrayList<Runnable>();
    private boolean zzru;
    private Set<zza> zzTY = new HashSet<zza>();
    private boolean zzTZ;
    private boolean zzUa;
    private volatile boolean zzUb;
    private boolean zzUc;

    public void initialize() {
        this.zzks();
        this.zzru = true;
    }

    void zzks() {
        Logger logger;
        zzap zzap2 = this.zzkx();
        if (zzap2.zznL()) {
            this.getLogger().setLogLevel(zzap2.getLogLevel());
        }
        if (zzap2.zznP()) {
            this.setDryRun(zzap2.zznQ());
        }
        if (zzap2.zznL() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzap2.getLogLevel());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInitialized() {
        if (!this.zzru) return false;
        if (false) return false;
        return true;
    }

    public GoogleAnalytics(zzf zzf2) {
        super(zzf2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzX(context).zzme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzkt() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzTX != null) {
                for (Runnable runnable : zzTX) {
                    runnable.run();
                }
                zzTX = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean bl) {
        this.zzUa = bl;
    }

    public boolean isDryRunEnabled() {
        return this.zzUa;
    }

    @TargetApi(value=14)
    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzTZ) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzTZ = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzTZ) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzTY) {
            zza2.zzo(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzTZ) {
            this.zzn(activity);
        }
    }

    void zzn(Activity activity) {
        for (zza zza2 : this.zzTY) {
            zza2.zzp(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzkj(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzam zzam2;
            zzan zzan2;
            Tracker tracker = new Tracker(this.zzkj(), null, null);
            if (n > 0 && (zzan2 = (zzan)(zzam2 = new zzam(this.zzkj())).zzav(n)) != null) {
                tracker.zza(zzan2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzTY.add(zza2);
        Context context = this.zzkj().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzTY.remove(zza2);
    }

    public void setAppOptOut(boolean bl) {
        this.zzUb = bl;
        if (this.zzUb) {
            this.zzkw().zzlI();
        }
    }

    public boolean getAppOptOut() {
        return this.zzUb;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzUc) {
            String string = zzy.zzXF.get();
            Log.i((String)zzy.zzXF.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzUc = true;
        }
    }

    public String zzku() {
        zzaa.zzdd((String)"getClientId can not be called from the main thread");
        return this.zzkj().zzmh().zzmP();
    }

    public void setLocalDispatchPeriod(int n) {
        this.zzkw().setLocalDispatchPeriod(n);
    }

    public void dispatchLocalHits() {
        this.zzkw().zzlJ();
    }

    void zzkv() {
        this.zzkw().zzlK();
    }

    private com.google.android.gms.analytics.internal.zzb zzkw() {
        return this.zzkj().zzkw();
    }

    private zzap zzkx() {
        return this.zzkj().zzkx();
    }

    @TargetApi(value=14)
    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzn(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzo(Activity var1);

        public void zzp(Activity var1);
    }
}

