/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzln;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzUK;
    private final Map<String, String> zzAd = new HashMap<String, String>();
    private final Map<String, String> zzUL = new HashMap<String, String>();
    private final zzad zzUM;
    private final zza zzUN;
    private ExceptionReporter zzUO;
    private zzan zzUP;

    Tracker(zzf zzf2, String string, zzad zzad2) {
        super(zzf2);
        if (string != null) {
            this.zzAd.put("&tid", string);
        }
        this.zzAd.put("useSecure", "1");
        this.zzAd.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzUM = zzad2 == null ? new zzad("tracking", this.zzlQ()) : zzad2;
        this.zzUN = new zza(zzf2);
    }

    @Override
    protected void zzkO() {
        String string;
        this.zzUN.initialize();
        String string2 = this.zzkx().zzkU();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzkx().zzkV()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzan zzan2) {
        String string;
        this.zzbG("Loading Tracker config values");
        this.zzUP = zzan2;
        if (this.zzUP.zzov()) {
            string = this.zzUP.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzUP.zzow()) {
            string = Double.toString(this.zzUP.zzox());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzUP.zzoy()) {
            int n = this.zzUP.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzUP.zzoz()) {
            boolean bl = this.zzUP.zzoA();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzUP.zzoB()) {
            boolean bl = this.zzUP.zzoC();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzUP.zzoD());
    }

    private boolean zzkP() {
        return this.zzUO != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzkP() == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzUO = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzUO);
                this.zzbG("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzUO.zzkr();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzbG("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long l) {
        this.zzUN.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzUN.enableAutoActivityTracking(bl);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzaa.zzz(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzaa.zzz(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        final long l = this.zzlQ().currentTimeMillis();
        if (this.zzkq().getAppOptOut()) {
            this.zzbH("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzkq().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzAd, hashMap);
        Tracker.zzb(map, hashMap);
        final boolean bl2 = zzao.zzi(this.zzAd.get("useSecure"), true);
        Tracker.zzc(this.zzUL, hashMap);
        this.zzUL.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzlR().zzh(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzlR().zzh(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzkQ();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzAd.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzAd.put("&a", Integer.toString(n));
            }
        }
        this.zzlT().zzf(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzUN.zzkR()) {
                    hashMap.put("sc", "start");
                }
                zzao.zzd(hashMap, "cid", Tracker.this.zzkq().zzku());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zzao.zza(d = zzao.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzlX();
                if (bl3) {
                    zzao.zzb(hashMap, "ate", zza2.zzlt());
                    zzao.zzc(hashMap, "adid", zza2.zzlE());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzln zzln2 = Tracker.this.zzlY().zzmx();
                zzao.zzc(hashMap, "an", zzln2.zzkU());
                zzao.zzc(hashMap, "av", zzln2.zzkV());
                zzao.zzc(hashMap, "aid", zzln2.zziC());
                zzao.zzc(hashMap, "aiid", zzln2.zzkW());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.zzWi);
                zzao.zzc(hashMap, "ul", Tracker.this.zzlZ().zznE().getLanguage());
                zzao.zzc(hashMap, "sr", Tracker.this.zzlZ().zznF());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzUM.zznY()) {
                    Tracker.this.zzlR().zzh(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzao.zzbX((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zzlR().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzao.zza(hashMap2, "uid", hashMap);
                zzao.zza(hashMap2, "an", hashMap);
                zzao.zza(hashMap2, "aid", hashMap);
                zzao.zza(hashMap2, "av", hashMap);
                zzao.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzkw().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzkw().zza(zzab3);
            }
        });
    }

    public String get(String string) {
        this.zzma();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzAd.containsKey(string)) {
            return this.zzAd.get(string);
        }
        if (string.equals("&ul")) {
            return zzao.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzlW().zzmP();
        }
        if (string.equals("&sr")) {
            return this.zzlZ().zznF();
        }
        if (string.equals("&aid")) {
            return this.zzlY().zzmx().zziC();
        }
        if (string.equals("&an")) {
            return this.zzlY().zzmx().zzkU();
        }
        if (string.equals("&av")) {
            return this.zzlY().zzmx().zzkV();
        }
        if (string.equals("&aiid")) {
            return this.zzlY().zzmx().zzkW();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzaa.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzAd.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzao.zzS(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzbJ("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzao.zzS(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzUL.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzUL.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzUL.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzUL.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzUL.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzUL.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzUL.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzUL.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzUL.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzUL.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzUK = bl;
    }

    boolean zzkQ() {
        return this.zzUK;
    }

    static String zzq(Activity activity) {
        zzaa.zzz((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzUY;
        private int zzUZ;
        private long zzVa;
        private boolean zzVb;
        private long zzVc;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.zzVa = -1L;
        }

        @Override
        protected void zzkO() {
        }

        public void setSessionTimeout(long l) {
            this.zzVa = l;
            this.zzkS();
        }

        public void enableAutoActivityTracking(boolean bl) {
            this.zzUY = bl;
            this.zzkS();
        }

        public synchronized boolean zzkR() {
            boolean bl = this.zzVb;
            this.zzVb = false;
            return bl;
        }

        private void zzkS() {
            if (this.zzVa >= 0L || this.zzUY) {
                this.zzkq().zza(Tracker.this.zzUN);
            } else {
                this.zzkq().zzb(Tracker.this.zzUN);
            }
        }

        @Override
        public void zzo(Activity activity) {
            if (this.zzUZ == 0 && this.zzkT()) {
                this.zzVb = true;
            }
            ++this.zzUZ;
            if (this.zzUY) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzUP != null ? Tracker.this.zzUP.zzr(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzq(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzp(Activity activity) {
            --this.zzUZ;
            this.zzUZ = Math.max(0, this.zzUZ);
            if (this.zzUZ == 0) {
                this.zzVc = this.zzlQ().elapsedRealtime();
            }
        }

        boolean zzkT() {
            return this.zzlQ().elapsedRealtime() >= this.zzVc + Math.max(1000L, this.zzVa);
        }
    }
}

