/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzabt;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzai;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzbv;
import com.google.android.gms.tagmanager.zzci;
import com.google.android.gms.tagmanager.zzcw;
import com.google.android.gms.tagmanager.zzdl;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzbnR;
    private final DataLayer zzbnS;
    private zzcw zzbnT;
    private Map<String, FunctionCallMacroCallback> zzbnU = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzbnV = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzbnW;
    private volatile String zzbnX = "";

    Container(Context context, DataLayer dataLayer, String string, long l, zzabt.zzc zzc2) {
        this.mContext = context;
        this.zzbnS = dataLayer;
        this.zzbnR = string;
        this.zzbnW = l;
        this.zza(zzc2);
    }

    Container(Context context, DataLayer dataLayer, String string, long l, zzaf.zzj zzj2) {
        this.mContext = context;
        this.zzbnS = dataLayer;
        this.zzbnR = string;
        this.zzbnW = l;
        this.zza(zzj2.zzjG);
        if (zzj2.zzjF != null) {
            this.zza(zzj2.zzjF);
        }
    }

    public String getContainerId() {
        return this.zzbnR;
    }

    public boolean getBoolean(String string) {
        zzcw zzcw2 = this.zzJl();
        if (zzcw2 == null) {
            zzbn.e("getBoolean called for closed container.");
            return zzdl.zzKQ();
        }
        try {
            return zzdl.zzk(zzcw2.zzgH(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbn.e(new StringBuilder(66 + String.valueOf(string2).length()).append("Calling getBoolean() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdl.zzKQ();
        }
    }

    public double getDouble(String string) {
        zzcw zzcw2 = this.zzJl();
        if (zzcw2 == null) {
            zzbn.e("getDouble called for closed container.");
            return zzdl.zzKP();
        }
        try {
            return zzdl.zzj(zzcw2.zzgH(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbn.e(new StringBuilder(65 + String.valueOf(string2).length()).append("Calling getDouble() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdl.zzKP();
        }
    }

    public long getLong(String string) {
        zzcw zzcw2 = this.zzJl();
        if (zzcw2 == null) {
            zzbn.e("getLong called for closed container.");
            return zzdl.zzKO();
        }
        try {
            return zzdl.zzi(zzcw2.zzgH(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbn.e(new StringBuilder(63 + String.valueOf(string2).length()).append("Calling getLong() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdl.zzKO();
        }
    }

    public String getString(String string) {
        zzcw zzcw2 = this.zzJl();
        if (zzcw2 == null) {
            zzbn.e("getString called for closed container.");
            return zzdl.zzKS();
        }
        try {
            return zzdl.zzg(zzcw2.zzgH(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbn.e(new StringBuilder(65 + String.valueOf(string2).length()).append("Calling getString() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdl.zzKS();
        }
    }

    public long getLastRefreshTime() {
        return this.zzbnW;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String string, FunctionCallMacroCallback functionCallMacroCallback) {
        if (functionCallMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzbnU;
        synchronized (map) {
            this.zzbnU.put(string, functionCallMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzbnU;
        synchronized (map) {
            this.zzbnU.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzgj(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzbnU;
        synchronized (map) {
            return this.zzbnU.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String string, FunctionCallTagCallback functionCallTagCallback) {
        if (functionCallTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzbnV;
        synchronized (map) {
            this.zzbnV.put(string, functionCallTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzbnV;
        synchronized (map) {
            this.zzbnV.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionCallTagCallback zzgk(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzbnV;
        synchronized (map) {
            return this.zzbnV.get(string);
        }
    }

    public void zzgl(String string) {
        this.zzJl().zzgl(string);
    }

    public String zzJk() {
        return this.zzbnX;
    }

    private void zza(zzaf.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzabt.zzc zzc2 = null;
        try {
            zzc2 = zzabt.zzb(zzf2);
        }
        catch (zzabt.zzg zzg2) {
            String string = String.valueOf(zzf2);
            String string2 = String.valueOf(zzg2.toString());
            zzbn.e(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Not loading resource: ").append(string).append(" because it is invalid: ").append(string2).toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzaf.zzi[] zziArray) {
        ArrayList<zzaf.zzi> arrayList = new ArrayList<zzaf.zzi>();
        for (zzaf.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzJl().zzJ(arrayList);
    }

    private void zza(zzabt.zzc zzc2) {
        this.zzbnX = zzc2.getVersion();
        zzai zzai2 = this.zzgm(this.zzbnX);
        zzcw zzcw2 = new zzcw(this.mContext, zzc2, this.zzbnS, new zza(), new zzb(), zzai2);
        this.zza(zzcw2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzbnS.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzbnR));
        }
    }

    zzai zzgm(String string) {
        if (zzci.zzKh().zzKi().equals((Object)zzci.zza.zzbqh)) {
            // empty if block
        }
        return new zzbv();
    }

    private synchronized void zza(zzcw zzcw2) {
        this.zzbnT = zzcw2;
    }

    private synchronized zzcw zzJl() {
        return this.zzbnT;
    }

    void release() {
        this.zzbnT = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzd(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzgk(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdl.zzKS();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzd(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzgj(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

