/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.annotation.TargetApi;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RawRes;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzci;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzda;
import com.google.android.gms.tagmanager.zzdb;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzs;
import com.google.android.gms.tagmanager.zzw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzbrv;
    private final Context mContext;
    private final DataLayer zzbnS;
    private final zzda zzbrw;
    private final ConcurrentMap<zzo, Boolean> zzbrx;
    private final zzs zzbqs;
    private static TagManager zzbry;

    TagManager(Context context, zza zza2, DataLayer dataLayer, zzda zzda2) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzbrw = zzda2;
        this.zzbrv = zza2;
        this.zzbrx = new ConcurrentHashMap<zzo, Boolean>();
        this.zzbnS = dataLayer;
        this.zzbnS.zza(new DataLayer.zzb(){

            @Override
            public void zzW(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzgJ(object.toString());
                }
            }
        });
        this.zzbnS.zza(new zzd(this.mContext));
        this.zzbqs = new zzs();
        this.zzKH();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzbry == null) {
                if (context == null) {
                    zzbn.e("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzs zzs2) {
                        return new zzp(context, tagManager, looper, string, n, zzs2);
                    }
                };
                zzw zzw2 = new zzw(context);
                zzbry = new TagManager(context, zza2, new DataLayer(zzw2), zzdb.zzKB());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbry;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzbnS;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String string, @RawRes int n) {
        zzp zzp2 = this.zzbrv.zza(this.mContext, this, null, string, n, this.zzbqs);
        zzp2.zzJp();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String string, @RawRes int n, Handler handler) {
        zzp zzp2 = this.zzbrv.zza(this.mContext, this, handler.getLooper(), string, n, this.zzbqs);
        zzp2.zzJp();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String string, @RawRes int n) {
        zzp zzp2 = this.zzbrv.zza(this.mContext, this, null, string, n, this.zzbqs);
        zzp2.zzJq();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String string, @RawRes int n, Handler handler) {
        zzp zzp2 = this.zzbrv.zza(this.mContext, this, handler.getLooper(), string, n, this.zzbqs);
        zzp2.zzJq();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String string, @RawRes int n) {
        zzp zzp2 = this.zzbrv.zza(this.mContext, this, null, string, n, this.zzbqs);
        zzp2.zzJr();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String string, @RawRes int n, Handler handler) {
        zzp zzp2 = this.zzbrv.zza(this.mContext, this, handler.getLooper(), string, n, this.zzbqs);
        zzp2.zzJr();
        return zzp2;
    }

    public void dispatch() {
        this.zzbrw.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean bl) {
        zzbn.setLogLevel(bl ? 2 : 5);
    }

    synchronized boolean zzr(Uri uri) {
        zzci zzci2 = zzci.zzKh();
        if (zzci2.zzr(uri)) {
            String string = zzci2.getContainerId();
            switch (zzci2.zzKi()) {
                case zzbqf: {
                    for (zzo zzo2 : this.zzbrx.keySet()) {
                        if (!zzo2.getContainerId().equals(string)) continue;
                        zzo2.zzgn(null);
                        zzo2.refresh();
                    }
                    break;
                }
                case zzbqg: 
                case zzbqh: {
                    for (zzo zzo3 : this.zzbrx.keySet()) {
                        if (zzo3.getContainerId().equals(string)) {
                            zzo3.zzgn(zzci2.zzKj());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzJm() == null) continue;
                        zzo3.zzgn(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void zza(zzo zzo2) {
        this.zzbrx.put(zzo2, true);
    }

    public boolean zzb(zzo zzo2) {
        return this.zzbrx.remove(zzo2) != null;
    }

    private void zzgJ(String string) {
        for (zzo zzo2 : this.zzbrx.keySet()) {
            zzo2.zzgl(string);
        }
    }

    @TargetApi(value=14)
    private void zzKH() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int n) {
                    if (n == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzs var6);
    }
}

