/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.tagmanager.zzac;
import com.google.android.gms.tagmanager.zzar;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzbs;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;

class zzde
implements zzac {
    private final String zzCy;
    private final Context mContext;
    private final zzb zzbrt;
    private final zza zzbru;

    zzde(zzb zzb2, Context context, zza zza2) {
        this.zzbrt = zzb2;
        this.mContext = context.getApplicationContext();
        this.zzbru = zza2;
        this.zzCy = this.zza("GoogleTagManager", "4.00", Build.VERSION.RELEASE, zzde.zzc(Locale.getDefault()), Build.MODEL, Build.ID);
    }

    zzde(Context context, zza zza2) {
        this(new zzb(){

            @Override
            public HttpURLConnection zzd(URL uRL) throws IOException {
                return (HttpURLConnection)uRL.openConnection();
            }
        }, context, zza2);
    }

    @Override
    public boolean zzJF() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbn.v("...no network connectivity");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzI(List<zzar> list) {
        int n = Math.min(list.size(), 40);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            zzar zzar2 = list.get(i);
            URL uRL = this.zzd(zzar2);
            if (uRL == null) {
                zzbn.zzaW("No destination: discarding hit.");
                this.zzbru.zzb(zzar2);
                continue;
            }
            HttpURLConnection httpURLConnection = null;
            InputStream inputStream = null;
            try {
                httpURLConnection = this.zzbrt.zzd(uRL);
                try {
                    if (bl) {
                        zzbs.zzbq(this.mContext);
                        bl = false;
                    }
                    httpURLConnection.setRequestProperty("User-Agent", this.zzCy);
                    int n2 = httpURLConnection.getResponseCode();
                    inputStream = httpURLConnection.getInputStream();
                    if (n2 != 200) {
                        zzbn.zzaW(new StringBuilder(25).append("Bad response: ").append(n2).toString());
                        this.zzbru.zzc(zzar2);
                        continue;
                    }
                    this.zzbru.zza(zzar2);
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                String string = String.valueOf(iOException.getClass().getSimpleName());
                zzbn.zzaW(string.length() != 0 ? "Exception sending hit: ".concat(string) : new String("Exception sending hit: "));
                zzbn.zzaW(iOException.getMessage());
                this.zzbru.zzc(zzar2);
            }
        }
    }

    String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    static String zzc(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    URL zzd(zzar zzar2) {
        String string = zzar2.zzJS();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            zzbn.e("Error trying to parse the GTM url.");
            return null;
        }
    }

    static interface zzb {
        public HttpURLConnection zzd(URL var1) throws IOException;
    }

    public static interface zza {
        public void zza(zzar var1);

        public void zzb(zzar var1);

        public void zzc(zzar var1);
    }
}

