/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzx;
import com.google.android.gms.common.internal.zzv;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzEw = new ArrayList<Runnable>();
    private boolean zznz;
    private boolean zzEx;
    private Set<zza> zzEy = new HashSet<zza>();
    private boolean zzEz;
    private boolean zzEA;
    private volatile boolean zzEB;
    private boolean zzEC;

    public void zzfV() {
        this.zzfW();
        this.zznz = true;
    }

    void zzfW() {
        Logger logger;
        zzam zzam2 = this.zzga();
        if (zzam2.zziH()) {
            this.getLogger().setLogLevel(zzam2.getLogLevel());
        }
        if (zzam2.zziL()) {
            this.setDryRun(zzam2.zziM());
        }
        if (zzam2.zziH() && (logger = zzad.getLogger()) != null) {
            logger.setLogLevel(zzam2.getLogLevel());
        }
    }

    public boolean isInitialized() {
        return this.zznz && !this.zzEx;
    }

    public GoogleAnalytics(zze context) {
        super(context);
    }

    public static GoogleAnalytics getInstance(Context context) {
        return zze.zzJ(context).zzgV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzfX() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzEw != null) {
                for (Runnable runnable : zzEw) {
                    runnable.run();
                }
                zzEw = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean dryRun) {
        this.zzEA = dryRun;
    }

    public boolean isDryRunEnabled() {
        return this.zzEA;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzEz) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzEz = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzEz) {
            this.zzl(activity);
        }
    }

    void zzl(Activity activity) {
        for (zza zza2 : this.zzEy) {
            zza2.zzn(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzEz) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzEy) {
            zza2.zzo(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzfO(), trackingId, null);
            tracker.zzfV();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzaj zzaj2;
            zzak zzak2;
            Tracker tracker = new Tracker(this.zzfO(), null, null);
            if (configResId > 0 && (zzak2 = (zzak)(zzaj2 = new zzaj(this.zzfO())).zzS(configResId)) != null) {
                tracker.zza(zzak2);
            }
            tracker.zzfV();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzEy.add(zza2);
        Context context = this.zzfO().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzEy.remove(zza2);
    }

    public void setAppOptOut(boolean optOut) {
        this.zzEB = optOut;
        if (this.zzEB) {
            this.zzfZ().zzgv();
        }
    }

    public boolean getAppOptOut() {
        return this.zzEB;
    }

    @Deprecated
    public Logger getLogger() {
        return zzad.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzad.setLogger(logger);
        if (!this.zzEC) {
            Log.i((String)zzx.zzHf.get(), (String)("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag." + zzx.zzHf.get() + " DEBUG"));
            this.zzEC = true;
        }
    }

    public String getClientId() {
        zzv.zzbJ((String)"getClientId can not be called from the main thread");
        return this.zzfO().zzgY().zzhI();
    }

    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zzfZ().setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    public void dispatchLocalHits() {
        this.zzfZ().zzgw();
    }

    void zzfY() {
        this.zzfZ().zzgx();
    }

    private com.google.android.gms.analytics.internal.zzb zzfZ() {
        return this.zzfO().zzfZ();
    }

    private zzam zzga() {
        return this.zzfO().zzga();
    }

    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzl(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzn(Activity var1);

        public void zzo(Activity var1);
    }
}

