/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzaa;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzkp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzEK;
    private final Map<String, String> zzvi = new HashMap<String, String>();
    private final Map<String, String> zzEL = new HashMap<String, String>();
    private final zzac zzEM;
    private final zza zzEN;
    private ExceptionReporter zzEO;
    private zzak zzEP;

    Tracker(zze analytics, String trackingId, zzac rateLimiter) {
        super(analytics);
        if (trackingId != null) {
            this.zzvi.put("&tid", trackingId);
        }
        this.zzvi.put("useSecure", "1");
        this.zzvi.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzEM = rateLimiter == null ? new zzac("tracking") : rateLimiter;
        this.zzEN = new zza(analytics);
    }

    @Override
    protected void zzgb() {
        String string;
        this.zzEN.zzfV();
        String string2 = this.zzga().zziE();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzga().zziG()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzak zzak2) {
        String string;
        this.zzaF("Loading Tracker config values");
        this.zzEP = zzak2;
        if (this.zzEP.zzjr()) {
            string = this.zzEP.zzjs();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzEP.zzjt()) {
            string = Double.toString(this.zzEP.zzju());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzEP.zzjv()) {
            int n = this.zzEP.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzEP.zzjw()) {
            boolean bl = this.zzEP.zzjx();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzEP.zzjy()) {
            boolean bl = this.zzEP.zzjz();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzEP.zzjA());
    }

    private boolean zzgc() {
        return this.zzEO != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzgc() == enable) {
                return;
            }
            if (enable) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzEO = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzEO);
                this.zzaF("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzEO.zzfU();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzaF("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzEN.setSessionTimeout(sessionTimeout * 1000L);
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzEN.enableAutoActivityTracking(enabled);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        zzv.zzr(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzv.zzr(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> params) {
        final long l = this.zzgG().currentTimeMillis();
        if (this.zzfT().getAppOptOut()) {
            this.zzaG("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzfT().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zzvi, hashMap);
        Tracker.zza(params, hashMap);
        final boolean bl2 = zzal.zze(this.zzvi.get("useSecure"), true);
        Tracker.zzb(this.zzEL, hashMap);
        this.zzEL.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzgH().zze(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzgH().zze(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzgd();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzvi.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzvi.put("&a", Integer.toString(n));
            }
        }
        this.zzgJ().zze(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzEN.zzge()) {
                    hashMap.put("sc", "start");
                }
                zzal.zzc(hashMap, "cid", Tracker.this.zzfT().getClientId());
                if (hashMap.get("&sf") != null && zzal.zza(d = zzal.zza((String)hashMap.get("&sf"), 100.0), (String)hashMap.get("&cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzgN();
                if (bl3) {
                    zzal.zzb((Map<String, String>)hashMap, "ate", zza2.zzgn());
                    zzal.zzb((Map<String, String>)hashMap, "adid", zza2.zzgr());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzkp zzkp2 = Tracker.this.zzgO().zzhq();
                zzal.zzb((Map<String, String>)hashMap, "an", zzkp2.zziE());
                zzal.zzb((Map<String, String>)hashMap, "av", zzkp2.zziG());
                zzal.zzb((Map<String, String>)hashMap, "aid", zzkp2.zzqT());
                zzal.zzb((Map<String, String>)hashMap, "aiid", zzkp2.zzus());
                hashMap.put("v", "1");
                hashMap.put("_v", "ma4.5.0");
                zzal.zzb((Map<String, String>)hashMap, "ul", Tracker.this.zzgP().zzix().getLanguage());
                zzal.zzb((Map<String, String>)hashMap, "sr", Tracker.this.zzgP().zziy());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzEM.zziU()) {
                    Tracker.this.zzgH().zze(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzal.zzaV((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzaa zzaa2 = new zzaa(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zzgH().zzc("Dry run enabled. Would have sent hit", zzaa2);
                    return;
                }
                String string3 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzal.zza(hashMap2, "uid", hashMap);
                zzal.zza(hashMap2, "an", hashMap);
                zzal.zza(hashMap2, "aid", hashMap);
                zzal.zza(hashMap2, "av", hashMap);
                zzal.zza(hashMap2, "aiid", hashMap);
                zzg zzg2 = new zzg(0L, string3, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzfZ().zza(zzg2);
                hashMap.put("_s", String.valueOf(l2));
                zzaa zzaa3 = new zzaa(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzfZ().zza(zzaa3);
            }
        });
    }

    public String get(String key) {
        this.zzgR();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzvi.containsKey(key)) {
            return this.zzvi.get(key);
        }
        if (key.equals("&ul")) {
            return zzal.zza(Locale.getDefault());
        }
        if (key.equals("&cid")) {
            return this.zzgM().zzhI();
        }
        if (key.equals("&sr")) {
            return this.zzgP().zziy();
        }
        if (key.equals("&aid")) {
            return this.zzgO().zzhq().zzqT();
        }
        if (key.equals("&an")) {
            return this.zzgO().zzhq().zziE();
        }
        if (key.equals("&av")) {
            return this.zzgO().zzhq().zziG();
        }
        if (key.equals("&aiid")) {
            return this.zzgO().zzhq().zzus();
        }
        return null;
    }

    public void set(String key, String value) {
        zzv.zzb((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.zzvi.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzal.zzH(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            this.zzaI("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzal.zzH(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string));
        String string2 = uri2.getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzEL.put("&ci", string2);
        }
        if ((string2 = uri2.getQueryParameter("anid")) != null) {
            this.zzEL.put("&anid", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzEL.put("&cn", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzEL.put("&cc", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzEL.put("&cm", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzEL.put("&cs", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzEL.put("&ck", string2);
        }
        if ((string2 = uri2.getQueryParameter("dclid")) != null) {
            this.zzEL.put("&dclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("gclid")) != null) {
            this.zzEL.put("&gclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("aclid")) != null) {
            this.zzEL.put("&aclid", string2);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        this.zzEK = enabled;
    }

    boolean zzgd() {
        return this.zzEK;
    }

    static String zzp(Activity activity) {
        zzv.zzr((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzEY;
        private int zzEZ;
        private long zzFa;
        private boolean zzFb;
        private long zzFc;

        protected zza(zze zze2) {
            super(zze2);
            this.zzFa = -1L;
        }

        @Override
        protected void zzgb() {
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.zzFa = sessionTimeout;
            this.zzgf();
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzEY = enabled;
            this.zzgf();
        }

        public synchronized boolean zzge() {
            boolean bl = this.zzFb;
            this.zzFb = false;
            return bl;
        }

        private void zzgf() {
            if (this.zzFa >= 0L || this.zzEY) {
                this.zzfT().zza(Tracker.this.zzEN);
            } else {
                this.zzfT().zzb(Tracker.this.zzEN);
            }
        }

        @Override
        public void zzn(Activity activity) {
            if (this.zzEZ == 0 && this.zzgg()) {
                this.zzFb = true;
            }
            ++this.zzEZ;
            if (this.zzEY) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzEP != null ? Tracker.this.zzEP.zzq(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzp(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzo(Activity activity) {
            --this.zzEZ;
            this.zzEZ = Math.max(0, this.zzEZ);
            if (this.zzEZ == 0) {
                this.zzFc = this.zzgG().elapsedRealtime();
            }
        }

        boolean zzgg() {
            return this.zzgG().elapsedRealtime() >= this.zzFc + Math.max(1000L, this.zzFa);
        }
    }
}

