/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzo;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

abstract class zzp<T extends zzo>
extends zzc {
    zza<T> zzGR;

    public zzp(zze zze2, zza<T> zza2) {
        super(zze2);
        this.zzGR = zza2;
    }

    public T zzS(int n) {
        try {
            return this.zza(this.zzgD().zzgT().getResources().getXml(n));
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzd("inflate() called with unknown resourceId", (Object)notFoundException);
            return null;
        }
    }

    private T zza(XmlResourceParser xmlResourceParser) {
        try {
            xmlResourceParser.next();
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (xmlResourceParser.getEventType() == 2) {
                    String string;
                    String string2;
                    String string3 = xmlResourceParser.getName().toLowerCase();
                    if (string3.equals("screenname")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            this.zzGR.zzj(string2, string);
                        }
                    } else if (string3.equals("string")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && string != null) {
                            this.zzGR.zzk(string2, string);
                        }
                    } else if (string3.equals("bool")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                boolean bl = Boolean.parseBoolean(string);
                                this.zzGR.zzc(string2, bl);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing bool configuration value", string, numberFormatException);
                            }
                        }
                    } else if (string3.equals("integer")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                int n2 = Integer.parseInt(string);
                                this.zzGR.zzc(string2, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing int configuration value", string, numberFormatException);
                            }
                        }
                    }
                }
                n = xmlResourceParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            this.zze("Error parsing tracker configuration file", (Object)xmlPullParserException);
        }
        catch (IOException iOException) {
            this.zze("Error parsing tracker configuration file", iOException);
        }
        return this.zzGR.zzhO();
    }

    public static interface zza<U extends zzo> {
        public void zzj(String var1, String var2);

        public void zzk(String var1, String var2);

        public void zzc(String var1, boolean var2);

        public void zzc(String var1, int var2);

        public U zzhO();
    }
}

