/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmr;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class zzms {
    public static final Integer zzaHy = 0;
    public static final Integer zzaHz = 1;
    private final Context mContext;
    private final ExecutorService zzaEN;

    public zzms(Context context) {
        this(context, Executors.newSingleThreadExecutor());
    }

    zzms(Context context, ExecutorService executorService) {
        this.mContext = context;
        this.zzaEN = executorService;
    }

    public void zza(final String string, final Integer n, final zzmm zzmm2, final zzmr zzmr2) {
        this.zzaEN.execute(new Runnable(){

            @Override
            public void run() {
                zzms.this.zzb(string, n, zzmm2, zzmr2);
            }
        });
    }

    void zzb(String string, Integer n, zzmm zzmm2, zzmr zzmr2) {
        Object object;
        InputStream inputStream;
        zzbg.zzam("DiskLoader: Starting to load resource from Disk.");
        try {
            inputStream = new FileInputStream(this.zzet(string));
            object = zzmm2.zzp(this.zzf(inputStream));
            if (object != null) {
                zzbg.zzam("Saved resource loaded: " + this.zzeu(string));
                zzmr2.zza(Status.zzQU, object, zzaHz, this.zzes(string));
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzak("Saved resource not found: " + this.zzeu(string));
        }
        catch (zzmq.zzg zzg2) {
            zzbg.zzak("Saved resource is corrupted: " + this.zzeu(string));
        }
        if (n == null) {
            zzmr2.zza(Status.zzQW, null, null, 0L);
            return;
        }
        try {
            inputStream = this.mContext.getResources().openRawResource(n.intValue());
            if (inputStream != null && (object = zzmm2.zzp(this.zzf(inputStream))) != null) {
                zzbg.zzam("Default resource loaded: " + this.mContext.getResources().getResourceEntryName(n.intValue()));
                zzmr2.zza(Status.zzQU, object, zzaHy, 0L);
                return;
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzak("Default resource not found. ID: " + n);
        }
        catch (zzmq.zzg zzg3) {
            zzbg.zzak("Default resource resource is corrupted: " + n);
        }
        zzmr2.zza(Status.zzQW, null, null, 0L);
    }

    public void zze(final String string, final byte[] byArray) {
        this.zzaEN.execute(new Runnable(){

            @Override
            public void run() {
                zzms.this.zzf(string, byArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzf(String string, byte[] byArray) {
        String string2;
        FileOutputStream fileOutputStream;
        File file = this.zzet(string);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "Error opening resource file for writing";
            zzbg.zzak(string3);
            return;
        }
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            string2 = "Error writing resource to disk. Removing resource from disk";
            zzbg.zzak(string2);
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
                zzbg.zzam("Resource " + string + " saved on Disk.");
            }
            catch (IOException iOException) {
                string2 = "Error closing stream for writing resource to disk";
                zzbg.zzak(string2);
            }
        }
    }

    public long zzes(String string) {
        File file = this.zzet(string);
        return file.exists() ? file.lastModified() : 0L;
    }

    File zzet(String string) {
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, this.zzeu(string));
    }

    private String zzeu(String string) {
        return "resource_" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzf(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            zzhy.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            zzbg.zzan("Failed to read the resource from disk");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzan("Error closing stream for reading resource from disk");
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

