/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzah;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzcp;
import com.google.android.gms.tagmanager.zzdf;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzaCk;
    private final DataLayer zzaCl;
    private zzcp zzaCm;
    private Map<String, FunctionCallMacroCallback> zzaCn = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzaCo = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzaCp;
    private volatile String zzaCq = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzmq.zzc resource) {
        this.mContext = context;
        this.zzaCl = dataLayer;
        this.zzaCk = containerId;
        this.zzaCp = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzc.zzj resource) {
        this.mContext = context;
        this.zzaCl = dataLayer;
        this.zzaCk = containerId;
        this.zzaCp = lastRefreshTime;
        this.zza(resource.zzhh);
        if (resource.zzhg != null) {
            this.zza(resource.zzhg);
        }
    }

    public String getContainerId() {
        return this.zzaCk;
    }

    public boolean getBoolean(String key) {
        zzcp zzcp2 = this.zzwt();
        if (zzcp2 == null) {
            zzbg.zzak("getBoolean called for closed container.");
            return zzdf.zzxT();
        }
        try {
            return zzdf.zzk(zzcp2.zzdV(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzak("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzxT();
        }
    }

    public double getDouble(String key) {
        zzcp zzcp2 = this.zzwt();
        if (zzcp2 == null) {
            zzbg.zzak("getDouble called for closed container.");
            return zzdf.zzxS();
        }
        try {
            return zzdf.zzj(zzcp2.zzdV(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzak("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzxS();
        }
    }

    public long getLong(String key) {
        zzcp zzcp2 = this.zzwt();
        if (zzcp2 == null) {
            zzbg.zzak("getLong called for closed container.");
            return zzdf.zzxR();
        }
        try {
            return zzdf.zzi(zzcp2.zzdV(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzak("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzxR();
        }
    }

    public String getString(String key) {
        zzcp zzcp2 = this.zzwt();
        if (zzcp2 == null) {
            zzbg.zzak("getString called for closed container.");
            return zzdf.zzxV();
        }
        try {
            return zzdf.zzg(zzcp2.zzdV(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzak("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzxV();
        }
    }

    public long getLastRefreshTime() {
        return this.zzaCp;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzaCn;
        synchronized (map) {
            this.zzaCn.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzaCn;
        synchronized (map) {
            this.zzaCn.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzdx(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzaCn;
        synchronized (map) {
            return this.zzaCn.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzaCo;
        synchronized (map) {
            this.zzaCo.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzaCo;
        synchronized (map) {
            this.zzaCo.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback zzdy(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzaCo;
        synchronized (map) {
            return this.zzaCo.get(string);
        }
    }

    void zzdz(String string) {
        this.zzwt().zzdz(string);
    }

    String zzws() {
        return this.zzaCq;
    }

    private void zza(zzc.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzmq.zzc zzc2 = null;
        try {
            zzc2 = zzmq.zzb(zzf2);
        }
        catch (zzmq.zzg zzg2) {
            zzbg.zzak("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzc.zzi[] zziArray) {
        ArrayList<zzc.zzi> arrayList = new ArrayList<zzc.zzi>();
        for (zzc.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzwt().zzt(arrayList);
    }

    private void zza(zzmq.zzc zzc2) {
        this.zzaCq = zzc2.getVersion();
        zzah zzah2 = this.zzdA(this.zzaCq);
        zzcp zzcp2 = new zzcp(this.mContext, zzc2, this.zzaCl, new zza(), new zzb(), zzah2);
        this.zza(zzcp2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzaCl.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzaCk));
        }
    }

    zzah zzdA(String string) {
        if (zzcb.zzxl().zzxm().equals((Object)zzcb.zza.zzaEw)) {
            // empty if block
        }
        return new zzbo();
    }

    private synchronized void zza(zzcp zzcp2) {
        this.zzaCm = zzcp2;
    }

    private synchronized zzcp zzwt() {
        return this.zzaCm;
    }

    void release() {
        this.zzaCm = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzdy(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdf.zzxV();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzdx(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

