/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import com.google.android.gms.tagmanager.zzbg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    public static final String EVENT_KEY = "event";
    static final String[] zzaCR = "gtm.lifetime".toString().split("\\.");
    private static final Pattern zzaCS = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<zzb, Integer> zzaCT;
    private final Map<String, Object> zzaCU;
    private final ReentrantLock zzaCV;
    private final LinkedList<Map<String, Object>> zzaCW;
    private final zzc zzaCX;
    private final CountDownLatch zzaCY;

    DataLayer() {
        this(new zzc(){

            @Override
            public void zza(List<zza> list, long l) {
            }

            @Override
            public void zza(zzc.zza zza2) {
                zza2.zzp(new ArrayList<zza>());
            }

            @Override
            public void zzdH(String string) {
            }
        });
    }

    DataLayer(zzc persistentStore) {
        this.zzaCX = persistentStore;
        this.zzaCT = new ConcurrentHashMap();
        this.zzaCU = new HashMap<String, Object>();
        this.zzaCV = new ReentrantLock();
        this.zzaCW = new LinkedList();
        this.zzaCY = new CountDownLatch(1);
        this.zzwE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> map = this.zzaCU;
        synchronized (map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.zzaCU.entrySet()) {
                stringBuilder.append(String.format("{\n\tKey: %s\n\tValue: %s\n}\n", entry.getKey(), entry.getValue()));
            }
            return stringBuilder.toString();
        }
    }

    public void pushEvent(String eventName, Map<String, Object> update) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(update);
        hashMap.put(EVENT_KEY, eventName);
        this.push(hashMap);
    }

    public void push(String key, Object value) {
        Map<String, Object> map = this.zzi(key, value);
        this.push(map);
    }

    public void push(Map<String, Object> update) {
        try {
            this.zzaCY.await();
        }
        catch (InterruptedException interruptedException) {
            zzbg.zzan("DataLayer.push: unexpected InterruptedException");
        }
        this.zzG(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzG(Map<String, Object> map) {
        this.zzaCV.lock();
        try {
            this.zzaCW.offer(map);
            if (this.zzaCV.getHoldCount() == 1) {
                this.zzwF();
            }
            this.zzH(map);
        }
        finally {
            this.zzaCV.unlock();
        }
    }

    private void zzwE() {
        this.zzaCX.zza(new zzc.zza(){

            @Override
            public void zzp(List<zza> list) {
                for (zza zza2 : list) {
                    DataLayer.this.zzG(DataLayer.this.zzi(zza2.zzra, zza2.zzCM));
                }
                DataLayer.this.zzaCY.countDown();
            }
        });
    }

    private void zzH(Map<String, Object> map) {
        Long l = this.zzI(map);
        if (l == null) {
            return;
        }
        List<zza> list = this.zzK(map);
        list.remove("gtm.lifetime");
        this.zzaCX.zza(list, l);
    }

    private Long zzI(Map<String, Object> map) {
        Object object = this.zzJ(map);
        if (object == null) {
            return null;
        }
        return DataLayer.zzdG(object.toString());
    }

    private Object zzJ(Map<String, Object> map) {
        Object object = map;
        for (String string : zzaCR) {
            if (!(object instanceof Map)) {
                return null;
            }
            Map<String, Object> map2 = object;
            object = map2.get(string);
        }
        return object;
    }

    void zzdF(String string) {
        this.push(string, null);
        this.zzaCX.zzdH(string);
    }

    private List<zza> zzK(Map<String, Object> map) {
        ArrayList<zza> arrayList = new ArrayList<zza>();
        this.zza(map, "", arrayList);
        return arrayList;
    }

    private void zza(Map<String, Object> map, String string, Collection<zza> collection) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = string + (string.length() == 0 ? "" : ".") + entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map map2 = (Map)entry.getValue();
                this.zza(map2, string2, collection);
                continue;
            }
            if (string2.equals("gtm.lifetime")) continue;
            collection.add(new zza(string2, entry.getValue()));
        }
    }

    static Long zzdG(String string) {
        Matcher matcher = zzaCS.matcher(string);
        if (!matcher.matches()) {
            zzbg.zzal("unknown _lifetime: " + string);
            return null;
        }
        long l = 0L;
        try {
            l = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            zzbg.zzan("illegal number in _lifetime value: " + string);
        }
        if (l <= 0L) {
            zzbg.zzal("non-positive _lifetime: " + string);
            return null;
        }
        String string2 = matcher.group(2);
        if (string2.length() == 0) {
            return l;
        }
        switch (string2.charAt(0)) {
            case 's': {
                return l * 1000L;
            }
            case 'm': {
                return l * 1000L * 60L;
            }
            case 'h': {
                return l * 1000L * 60L * 60L;
            }
            case 'd': {
                return l * 1000L * 60L * 60L * 24L;
            }
        }
        zzbg.zzan("unknown units in _lifetime: " + string);
        return null;
    }

    private void zzwF() {
        Map<String, Object> map;
        int n = 0;
        while ((map = this.zzaCW.poll()) != null) {
            this.zzL(map);
            if (++n <= 500) continue;
            this.zzaCW.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzL(Map<String, Object> map) {
        Map<String, Object> map2 = this.zzaCU;
        synchronized (map2) {
            for (String string : map.keySet()) {
                this.zzc(this.zzi(string, map.get(string)), this.zzaCU);
            }
        }
        this.zzM(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<String, Object> map = this.zzaCU;
        synchronized (map) {
            String[] stringArray;
            Object object = this.zzaCU;
            for (String string : stringArray = key.split("\\.")) {
                if (!(object instanceof Map)) {
                    return null;
                }
                Object object2 = object;
                Object object3 = object2.get(string);
                if (object3 == null) {
                    return null;
                }
                object = object3;
            }
            return object;
        }
    }

    public static Map<String, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            if (!(objects[i] instanceof String)) {
                throw new IllegalArgumentException("key is not a string: " + objects[i]);
            }
            hashMap.put((String)objects[i], objects[i + 1]);
        }
        return hashMap;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            arrayList.add(objects[i]);
        }
        return arrayList;
    }

    void zza(zzb zzb2) {
        this.zzaCT.put(zzb2, 0);
    }

    private void zzM(Map<String, Object> map) {
        for (zzb zzb2 : this.zzaCT.keySet()) {
            zzb2.zzE(map);
        }
    }

    Map<String, Object> zzi(String string, Object object) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap = new HashMap<String, Object>();
        String[] stringArray = string.toString().split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            HashMap hashMap3 = new HashMap();
            hashMap2.put(stringArray[i], hashMap3);
            hashMap2 = hashMap3;
        }
        hashMap2.put(stringArray[stringArray.length - 1], object);
        return hashMap;
    }

    void zzc(Map<String, Object> map, Map<String, Object> map2) {
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            Object object3 = map.get(string);
            if (object3 instanceof List) {
                if (!(map2.get(string) instanceof List)) {
                    map2.put(string, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)map2.get(string);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(map2.get(string) instanceof Map)) {
                    map2.put(string, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)map2.get(string);
                this.zzc((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            map2.put(string, object3);
        }
    }

    void zzb(List<Object> list, List<Object> list2) {
        while (list2.size() < list.size()) {
            list2.add(null);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3 = list.get(i);
            if (object3 instanceof List) {
                if (!(list2.get(i) instanceof List)) {
                    list2.set(i, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)list2.get(i);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(list2.get(i) instanceof Map)) {
                    list2.set(i, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)list2.get(i);
                this.zzc((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            if (object3 == OBJECT_NOT_PRESENT) continue;
            list2.set(i, object3);
        }
    }

    static interface zzc {
        public void zza(List<com.google.android.gms.tagmanager.DataLayer$zza> var1, long var2);

        public void zza(zza var1);

        public void zzdH(String var1);

        public static interface zza {
            public void zzp(List<com.google.android.gms.tagmanager.DataLayer$zza> var1);
        }
    }

    static final class zza {
        public final String zzra;
        public final Object zzCM;

        zza(String string, Object object) {
            this.zzra = string;
            this.zzCM = object;
        }

        public String toString() {
            return "Key: " + this.zzra + " value: " + this.zzCM.toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.zzra.hashCode(), this.zzCM.hashCode()});
        }

        public boolean equals(Object o) {
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return this.zzra.equals(zza2.zzra) && this.zzCM.equals(zza2.zzCM);
        }
    }

    static interface zzb {
        public void zzE(Map<String, Object> var1);
    }
}

