/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzom;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzof {
    private static volatile zzof zzaId;
    private final Context mContext;
    private final List<zzog> zzaIe;
    private final zzoa zzaIf;
    private final zza zzaIg;
    private volatile zzok zzMm;
    private Thread.UncaughtExceptionHandler zzaIh;

    zzof(Context context) {
        Context context2 = context.getApplicationContext();
        zzx.zzv((Object)context2);
        this.mContext = context2;
        this.zzaIg = new zza();
        this.zzaIe = new CopyOnWriteArrayList<zzog>();
        this.zzaIf = new zzoa();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzof zzaI(Context context) {
        zzx.zzv((Object)context);
        if (zzaId != null) return zzaId;
        Class<zzof> clazz = zzof.class;
        synchronized (zzof.class) {
            if (zzaId != null) return zzaId;
            zzaId = new zzof(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzok zzxu() {
        if (this.zzMm == null) {
            zzof zzof2 = this;
            synchronized (zzof2) {
                if (this.zzMm == null) {
                    zzok zzok2 = new zzok();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzok2.setAppId(string);
                    zzok2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GAv4", (String)("Error retrieving package info: appName set to " + string2));
                    }
                    zzok2.setAppName(string2);
                    zzok2.setAppVersion(string3);
                    this.zzMm = zzok2;
                }
            }
        }
        return this.zzMm;
    }

    public zzom zzxv() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzom zzom2 = new zzom();
        zzom2.setLanguage(zzam.zza(Locale.getDefault()));
        zzom2.zzhO(displayMetrics.widthPixels);
        zzom2.zzhP(displayMetrics.heightPixels);
        return zzom2;
    }

    void zze(zzob zzob2) {
        if (zzob2.zzxq()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzob2.zzxm()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final zzob zzob3 = zzob2.zzxh();
        zzob3.zzxn();
        this.zzaIg.execute(new Runnable(){

            @Override
            public void run() {
                zzoe zzoe2 = zzob3.zzxo();
                zzoe2.zza(zzob3);
                for (zzog zzog2 : zzof.this.zzaIe) {
                    zzog2.zza(zzob3);
                }
                zzof.this.zzb(zzob3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzic() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaIh = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzb(Callable<V> callable) {
        zzx.zzv(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaIg.submit(callable);
    }

    public void zzf(Runnable runnable) {
        zzx.zzv((Object)runnable);
        this.zzaIg.submit(runnable);
    }

    private void zzb(zzob zzob2) {
        zzx.zzci((String)"deliver should be called from worker thread");
        zzx.zzb((boolean)zzob2.zzxm(), (Object)"Measurement must be submitted");
        List<zzoh> list = zzob2.zzxj();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzoh zzoh2 : list) {
            Uri uri = zzoh2.zzhs();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzoh2.zzb(zzob2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaIl = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string = "measurement-" + zzaIl.incrementAndGet();
            return new zzc(target, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new FutureTask<T>(runnable, value){

                @Override
                protected void setException(Throwable error) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzof.this.zzaIh;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), error);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        Log.e((String)"GAv4", (String)("MeasurementExecutor: job failed with " + error));
                    }
                    super.setException(error);
                }
            };
        }
    }
}

