/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzNK = new ArrayList<Runnable>();
    private boolean zzqh;
    private boolean zzNL;
    private Set<zza> zzNM = new HashSet<zza>();
    private boolean zzNN;
    private boolean zzNO;
    private volatile boolean zzNP;
    private boolean zzNQ;

    public void zza() {
        this.zzim();
        this.zzqh = true;
    }

    void zzim() {
        Logger logger;
        zzan zzan2 = this.zziq();
        if (zzan2.zzkS()) {
            this.getLogger().setLogLevel(zzan2.getLogLevel());
        }
        if (zzan2.zzkW()) {
            this.setDryRun(zzan2.zzkX());
        }
        if (zzan2.zzkS() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzan2.getLogLevel());
        }
    }

    public boolean isInitialized() {
        return this.zzqh && !this.zzNL;
    }

    public GoogleAnalytics(zzf context) {
        super(context);
    }

    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzZ(context).zzji();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzin() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzNK != null) {
                for (Runnable runnable : zzNK) {
                    runnable.run();
                }
                zzNK = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean dryRun) {
        this.zzNO = dryRun;
    }

    public boolean isDryRunEnabled() {
        return this.zzNO;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzNN) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzNN = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzNN) {
            this.zzl(activity);
        }
    }

    void zzl(Activity activity) {
        for (zza zza2 : this.zzNM) {
            zza2.zzn(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzNN) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzNM) {
            zza2.zzo(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzif(), trackingId, null);
            tracker.zza();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzak zzak2;
            zzal zzal2;
            Tracker tracker = new Tracker(this.zzif(), null, null);
            if (configResId > 0 && (zzal2 = (zzal)(zzak2 = new zzak(this.zzif())).zzah(configResId)) != null) {
                tracker.zza(zzal2);
            }
            tracker.zza();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzNM.add(zza2);
        Context context = this.zzif().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzNM.remove(zza2);
    }

    public void setAppOptOut(boolean optOut) {
        this.zzNP = optOut;
        if (this.zzNP) {
            this.zzip().zziK();
        }
    }

    public boolean getAppOptOut() {
        return this.zzNP;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzNQ) {
            Log.i((String)zzy.zzQr.get(), (String)("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag." + zzy.zzQr.get() + " DEBUG"));
            this.zzNQ = true;
        }
    }

    public String getClientId() {
        zzx.zzcy((String)"getClientId can not be called from the main thread");
        return this.zzif().zzjl().zzjT();
    }

    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zzip().setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    public void dispatchLocalHits() {
        this.zzip().zziL();
    }

    void zzio() {
        this.zzip().zziM();
    }

    private com.google.android.gms.analytics.internal.zzb zzip() {
        return this.zzif().zzip();
    }

    private zzan zziq() {
        return this.zzif().zziq();
    }

    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzl(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzn(Activity var1);

        public void zzo(Activity var1);
    }
}

