/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.os.Process;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zznl;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.tagmanager.zzbg;
import java.io.IOException;

public class zza {
    private volatile long zzbcm = 900000L;
    private volatile long zzbcn = 30000L;
    private volatile boolean mClosed = false;
    private volatile AdvertisingIdClient.Info zzOC;
    private volatile long zzbco;
    private volatile long zzbcp;
    private final Context mContext;
    private final zznl zzqD;
    private final Thread zzKt;
    private final Object zzbcq = new Object();
    private zza zzbcr = new zza(){

        @Override
        public AdvertisingIdClient.Info zzDZ() {
            AdvertisingIdClient.Info info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)zza.this.mContext);
            }
            catch (IllegalStateException illegalStateException) {
                zzbg.zzd("IllegalStateException getting Advertising Id Info", illegalStateException);
            }
            catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                zzbg.zzd("GooglePlayServicesRepairableException getting Advertising Id Info", googlePlayServicesRepairableException);
            }
            catch (IOException iOException) {
                zzbg.zzd("IOException getting Ad Id Info", iOException);
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                zzbg.zzd("GooglePlayServicesNotAvailableException getting Advertising Id Info", googlePlayServicesNotAvailableException);
            }
            catch (Exception exception) {
                zzbg.zzd("Unknown exception. Could not get the Advertising Id Info.", exception);
            }
            return info;
        }
    };
    private static Object zzbcs = new Object();
    private static zza zzbct;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zza zzaW(Context context) {
        if (zzbct == null) {
            Object object = zzbcs;
            synchronized (object) {
                if (zzbct == null) {
                    zzbct = new zza(context);
                    zzbct.start();
                }
            }
        }
        return zzbct;
    }

    private zza(Context context) {
        this(context, null, zzno.zzrM());
    }

    public zza(Context context, zza zza2, zznl zznl2) {
        this.zzqD = zznl2;
        this.mContext = context != null ? context.getApplicationContext() : context;
        if (zza2 != null) {
            this.zzbcr = zza2;
        }
        this.zzbco = this.zzqD.currentTimeMillis();
        this.zzKt = new Thread(new Runnable(){

            @Override
            public void run() {
                zza.this.zzDY();
            }
        });
    }

    public String zzDU() {
        if (this.zzOC == null) {
            this.zzDV();
        } else {
            this.zzDW();
        }
        this.zzDX();
        return this.zzOC == null ? null : this.zzOC.getId();
    }

    public boolean isLimitAdTrackingEnabled() {
        if (this.zzOC == null) {
            this.zzDV();
        } else {
            this.zzDW();
        }
        this.zzDX();
        return this.zzOC == null ? true : this.zzOC.isLimitAdTrackingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzDV() {
        zza zza2 = this;
        synchronized (zza2) {
            try {
                this.zzDW();
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzDW() {
        if (this.zzqD.currentTimeMillis() - this.zzbco > this.zzbcn) {
            Object object = this.zzbcq;
            synchronized (object) {
                this.zzbcq.notify();
            }
            this.zzbco = this.zzqD.currentTimeMillis();
        }
    }

    private void zzDX() {
        if (this.zzqD.currentTimeMillis() - this.zzbcp > 3600000L) {
            this.zzOC = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzDY() {
        Process.setThreadPriority((int)10);
        while (!this.mClosed) {
            AdvertisingIdClient.Info info = this.zzbcr.zzDZ();
            if (info != null) {
                this.zzOC = info;
                this.zzbcp = this.zzqD.currentTimeMillis();
                zzbg.zzaG("Obtained fresh AdvertisingId info from GmsCore.");
            }
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            try {
                object = this.zzbcq;
                synchronized (object) {
                    this.zzbcq.wait(this.zzbcm);
                }
            }
            catch (InterruptedException interruptedException) {
                zzbg.zzaG("sleep interrupted in AdvertiserDataPoller thread; continuing");
            }
        }
    }

    public void start() {
        this.zzKt.start();
    }

    public static interface zza {
        public AdvertisingIdClient.Info zzDZ();
    }
}

