/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzsh;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcn
implements zzp.zzf {
    private final Context mContext;
    private final String zzbcF;
    private final ExecutorService zzbfg;
    private zzbf<zzsf.zza> zzbeZ;

    zzcn(Context context, String string) {
        this.mContext = context;
        this.zzbcF = string;
        this.zzbfg = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbf<zzsf.zza> zzbf2) {
        this.zzbeZ = zzbf2;
    }

    @Override
    public void zzEp() {
        this.zzbfg.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzFg();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzFg() {
        if (this.zzbeZ == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzbeZ.zzEo();
        zzbg.v("Attempting to load resource from disk");
        if ((zzcb.zzEY().zzEZ() == zzcb.zza.zzbeO || zzcb.zzEY().zzEZ() == zzcb.zza.zzbeP) && this.zzbcF.equals(zzcb.zzEY().getContainerId())) {
            this.zzbeZ.zza(zzbf.zza.zzben);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzFh());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaF("Failed to find the resource in the disk");
            this.zzbeZ.zza(zzbf.zza.zzben);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzsh.zzb(fileInputStream, byteArrayOutputStream);
            zzsf.zza zza2 = zzsf.zza.zzx(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzbeZ.zzI(zza2);
        }
        catch (IOException iOException) {
            this.zzbeZ.zza(zzbf.zza.zzbeo);
            zzbg.zzaH("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzbeZ.zza(zzbf.zza.zzbeo);
            zzbg.zzaH("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaH("Error closing stream for reading resource from disk");
            }
        }
        zzbg.v("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzsf.zza zza2) {
        this.zzbfg.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzsh.zzc zzjN(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzaH("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbg.v("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzsh.zzb(inputStream, byteArrayOutputStream);
            zzsh.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzw(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbg.zzaH("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzsh.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzaz.zzfu(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbg.zzaF("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbg.zzaH("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzsh.zzc zzw(byte[] byArray) {
        try {
            zzsh.zzc zzc2 = zzsh.zzb(zzaf.zzf.zzc(byArray));
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zztj zztj2) {
            zzbg.e("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzsh.zzg zzg2) {
            zzbg.zzaH("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzbfg.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzsf.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzFh();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.e("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zztk.toByteArray((zztk)zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbg.zzaH("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaH("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzFh() {
        String string = "resource_" + this.zzbcF;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void zzd(zzsf.zza zza2) throws IllegalArgumentException {
        if (zza2.zzjl == null && zza2.zzbgY == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

