/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;

class zzag
extends BroadcastReceiver {
    static final String zzSZ = zzag.class.getName();
    private final zzf zzQj;
    private boolean zzTa;
    private boolean zzTb;

    zzag(zzf zzf2) {
        zzx.zzz((Object)zzf2);
        this.zzQj = zzf2;
    }

    public void onReceive(Context ctx, Intent intent) {
        this.zzlz();
        String string = intent.getAction();
        this.zzQj.zzjm().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzlB();
            if (this.zzTb != bl) {
                this.zzTb = bl;
                this.zziH().zzJ(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzSZ)) {
                this.zziH().zzjg();
            }
            return;
        }
        this.zzQj.zzjm().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzly() {
        this.zzlz();
        if (this.zzTa) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzTb = this.zzlB();
        this.zzQj.zzjm().zza("Registering connectivity change receiver. Network connected", this.zzTb);
        this.zzTa = true;
    }

    private void zzlz() {
        this.zzjm();
        this.zziH();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzQj.zzjm().zzbd("Unregistering connectivity change receiver");
        this.zzTa = false;
        this.zzTb = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzjm().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzlA() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzSZ, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzTa;
    }

    public boolean isConnected() {
        if (!this.zzTa) {
            this.zzQj.zzjm().zzbg("Connectivity unknown. Receiver not registered");
        }
        return this.zzTb;
    }

    protected boolean zzlB() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzQj.getContext();
    }

    private zzaf zzjm() {
        return this.zzQj.zzjm();
    }

    private zzb zziH() {
        return this.zzQj.zziH();
    }
}

