/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzrv;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzs;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzcl
implements Runnable {
    private final Context mContext;
    private final zzrw zzbke;
    private final String zzbhM;
    private final String zzbkf;
    private zzbf<zzaf.zzj> zzbkg;
    private volatile zzs zzbkh;
    private volatile String zzbij;
    private volatile String zzbki;

    public zzcl(Context context, String string, zzs zzs2) {
        this(context, string, new zzrw(), zzs2);
    }

    zzcl(Context context, String string, zzrw zzrw2, zzs zzs2) {
        this.mContext = context;
        this.zzbke = zzrw2;
        this.zzbhM = string;
        this.zzbkh = zzs2;
        this.zzbij = this.zzbkf = "/r?id=" + string;
        this.zzbki = null;
    }

    @Override
    public void run() {
        if (this.zzbkg == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzbkg.zzGk();
        this.zzGY();
    }

    private boolean zzGX() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.v("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbf<zzaf.zzj> zzbf2) {
        this.zzbkg = zzbf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zzGY() {
        block12: {
            if (!this.zzGX()) {
                this.zzbkg.zza(zzbf.zza.zzbju);
                return;
            }
            zzbg.v("Start loading resource from network ...");
            String string = this.zzGZ();
            InputStream inputStream = null;
            try (zzrv zzrv2 = this.zzbke.zzIa();){
                try {
                    inputStream = zzrv2.zzgI(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzaK("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzbhM + " is correct.");
                    this.zzbkg.zza(zzbf.zza.zzbjw);
                    zzrv2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzbkg.zza(zzbf.zza.zzbjv);
                    zzrv2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzrs.zzb(inputStream, byteArrayOutputStream);
                    zzaf.zzj zzj2 = zzaf.zzj.zzd(byteArrayOutputStream.toByteArray());
                    zzbg.v("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zzju == null && zzj2.zzjt.length == 0) {
                        zzbg.v("No change for container: " + this.zzbhM);
                    }
                    this.zzbkg.zzI(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzbkg.zza(zzbf.zza.zzbjw);
                    zzrv2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.v("Load resource from network finished.");
    }

    String zzGZ() {
        String string = this.zzbkh.zzGm() + this.zzbij + "&v=a65833898";
        if (this.zzbki != null && !this.zzbki.trim().equals("")) {
            string = string + "&pv=" + this.zzbki;
        }
        if (zzcb.zzGU().zzGV().equals((Object)zzcb.zza.zzbjW)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzfW(String string) {
        if (string == null) {
            this.zzbij = this.zzbkf;
        } else {
            zzbg.zzaI("Setting CTFE URL path: " + string);
            this.zzbij = string;
        }
    }

    void zzgl(String string) {
        zzbg.zzaI("Setting previous container version: " + string);
        this.zzbki = string;
    }
}

